/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.graalvm.buildtools.maven.AbstractNativeMojo;
import org.graalvm.reachability.DirectoryConfiguration;

@Mojo(name="add-reachability-metadata", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class AddReachabilityMetadataMojo
extends AbstractNativeMojo {
    private static final Set<String> SCOPES;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configureMetadataRepository();
        this.project.getArtifacts().stream().filter(this::isInScope).forEach(dependency -> this.maybeAddDependencyMetadata((Artifact)dependency, null));
        if (this.isMetadataRepositoryEnabled() && !this.metadataRepositoryConfigurations.isEmpty()) {
            Path destination = this.outputDirectory.toPath();
            try {
                DirectoryConfiguration.copy((Collection)this.metadataRepositoryConfigurations, (Path)destination);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
    }

    private boolean isInScope(Artifact artifact) {
        return SCOPES.contains(artifact.getScope());
    }

    static {
        HashSet<String> scopes = new HashSet<String>();
        scopes.add("compile");
        scopes.add("runtime");
        scopes.add("compile+runtime");
        SCOPES = Collections.unmodifiableSet(scopes);
    }
}

