/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainEvent;

public class ShutdownEvent
implements FilterChainEvent {
    public static final Object TYPE = ShutdownEvent.class.getName();
    private Set<Callable<Filter>> shutdownFutures;
    private long gracePeriod;
    private TimeUnit timeUnit;

    public ShutdownEvent(long gracePeriod, TimeUnit timeUnit) {
        this.gracePeriod = gracePeriod;
        this.timeUnit = timeUnit;
    }

    @Override
    public Object type() {
        return TYPE;
    }

    public void addShutdownTask(Callable<Filter> future) {
        if (future == null) {
            return;
        }
        if (this.shutdownFutures == null) {
            this.shutdownFutures = new LinkedHashSet<Callable<Filter>>(4);
        }
        this.shutdownFutures.add(future);
    }

    public Set<Callable<Filter>> getShutdownTasks() {
        return this.shutdownFutures != null ? this.shutdownFutures : Collections.emptySet();
    }

    public long getGracePeriod() {
        return this.gracePeriod;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

