/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.asyncqueue;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class TaskQueue<E> {
    private final Queue<E> queue;
    private final AtomicReference<E> currentElement;
    private final AtomicInteger spaceInBytes = new AtomicInteger();
    protected final AtomicReference<QueueMonitor> queueMonitor = new AtomicReference();

    protected TaskQueue() {
        this.currentElement = new AtomicReference();
        this.queue = new ConcurrentLinkedQueue();
    }

    public static <E> TaskQueue<E> createTaskQueue() {
        return new TaskQueue<E>();
    }

    public int reserveSpace(int amount) {
        return this.spaceInBytes.addAndGet(amount);
    }

    public int releaseSpace(int amount) {
        return this.spaceInBytes.addAndGet(-amount);
    }

    public int releaseSpaceAndNotify(int amount) throws IOException {
        int space = this.releaseSpace(amount);
        this.doNotify();
        return space;
    }

    public int spaceInBytes() {
        return this.spaceInBytes.get();
    }

    public E obtainCurrentElement() {
        E current = this.currentElement.get();
        return current != null ? current : this.queue.poll();
    }

    public E obtainCurrentElementAndReserve() {
        E current = this.currentElement.getAndSet(null);
        return current != null ? current : (E)this.queue.poll();
    }

    public void setQueueMonitor(QueueMonitor monitor) throws IOException {
        if (monitor == null) {
            this.removeQueueMonitor();
            return;
        }
        if (!this.queueMonitor.compareAndSet(null, monitor)) {
            throw new IllegalStateException("Illegal attempt to set a new monitor before the existing monitor has been notified.");
        }
        if (monitor.shouldNotify() && this.queueMonitor.compareAndSet(monitor, null)) {
            monitor.onNotify();
        }
    }

    public void removeQueueMonitor() {
        this.queueMonitor.set(null);
    }

    protected void doNotify() throws IOException {
        QueueMonitor monitor = this.queueMonitor.get();
        if (monitor != null && monitor.shouldNotify() && this.queueMonitor.compareAndSet(monitor, null)) {
            monitor.onNotify();
        }
    }

    public void setCurrentElement(E task) {
        this.currentElement.set(task);
    }

    public boolean remove(E task) {
        return this.queue.remove(task);
    }

    public void offer(E task) {
        this.queue.offer(task);
    }

    public boolean isEmpty() {
        return this.spaceInBytes.get() == 0;
    }

    public static abstract class QueueMonitor {
        public abstract void onNotify() throws IOException;

        public abstract boolean shouldNotify();
    }
}

