/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sqlserver.SQLServerConnection;
import org.flywaydb.core.internal.database.sqlserver.SQLServerEngineEdition;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLServerDatabase
extends Database<SQLServerConnection> {
    public SQLServerDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    protected SQLServerConnection doGetConnection(Connection connection) {
        return new SQLServerConnection(this, connection);
    }

    @Override
    public final void ensureSupported() {
        if (this.isAzure()) {
            this.ensureDatabaseIsRecentEnough("11.0");
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("12.0", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("12.0");
        } else {
            this.ensureDatabaseIsRecentEnough("10.0");
            this.ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition("13.0", Edition.ENTERPRISE);
            this.recommendFlywayUpgradeIfNecessary("15.0");
        }
    }

    @Override
    protected String computeVersionDisplayName(MigrationVersion version) {
        if (this.isAzure()) {
            return "Azure v" + this.getVersion().getMajorAsString();
        }
        if (this.getVersion().isAtLeast("8")) {
            if ("8".equals(this.getVersion().getMajorAsString())) {
                return "2000";
            }
            if ("9".equals(this.getVersion().getMajorAsString())) {
                return "2005";
            }
            if ("10".equals(this.getVersion().getMajorAsString())) {
                if ("0".equals(this.getVersion().getMinorAsString())) {
                    return "2008";
                }
                return "2008 R2";
            }
            if ("11".equals(this.getVersion().getMajorAsString())) {
                return "2012";
            }
            if ("12".equals(this.getVersion().getMajorAsString())) {
                return "2014";
            }
            if ("13".equals(this.getVersion().getMajorAsString())) {
                return "2016";
            }
            if ("14".equals(this.getVersion().getMajorAsString())) {
                return "2017";
            }
            if ("15".equals(this.getVersion().getMajorAsString())) {
                return "2019";
            }
        }
        return super.computeVersionDisplayName(version);
    }

    @Override
    public Delimiter getDefaultDelimiter() {
        return Delimiter.GO;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((SQLServerConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SUSER_SNAME()", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, "]", "]]");
    }

    @Override
    public String doQuote(String identifier) {
        return "[" + this.escapeIdentifier(identifier) + "]";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String filegroup = this.isAzure() || this.configuration.getTablespace() == null ? "" : " ON \"" + this.configuration.getTablespace() + "\"";
        return "CREATE TABLE " + table + " (\n    [installed_rank] INT NOT NULL,\n    [version] NVARCHAR(50),\n    [description] NVARCHAR(200),\n    [type] NVARCHAR(20) NOT NULL,\n    [script] NVARCHAR(1000) NOT NULL,\n    [checksum] INT,\n    [installed_by] NVARCHAR(100) NOT NULL,\n    [installed_on] DATETIME NOT NULL DEFAULT GETDATE(),\n    [execution_time] INT NOT NULL,\n    [success] BIT NOT NULL\n)" + filegroup + ";\n" + (baseline ? this.getBaselineStatement(table) + ";\n" : "") + "ALTER TABLE " + table + " ADD CONSTRAINT [" + table.getName() + "_pk] PRIMARY KEY ([installed_rank]);\nCREATE INDEX [" + table.getName() + "_s_idx] ON " + table + " ([success]);\nGO\n";
    }

    boolean isAzure() {
        return ((SQLServerConnection)this.getMainConnection()).isAzureConnection();
    }

    SQLServerEngineEdition getEngineEdition() {
        return ((SQLServerConnection)this.getMainConnection()).getEngineEdition();
    }

    boolean supportsTemporalTables() {
        return this.isAzure() || this.getVersion().isAtLeast("13.0");
    }

    protected boolean supportsPartitions() {
        return this.isAzure() || SQLServerEngineEdition.ENTERPRISE.equals((Object)this.getEngineEdition()) || this.getVersion().isAtLeast("13");
    }

    protected boolean supportsSequences() {
        return this.getVersion().isAtLeast("11");
    }

    protected boolean supportsSynonyms() {
        return true;
    }

    protected boolean supportsRules() {
        return true;
    }

    protected boolean supportsTypes() {
        return true;
    }

    protected boolean supportsTriggers() {
        return true;
    }

    protected boolean supportsAssemblies() {
        return true;
    }

    @Override
    protected void doCleanPostSchemas(Schema[] schemas) throws SQLException {
        if (this.supportsPartitions()) {
            for (String statement : this.cleanPartitionSchemes()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
            for (String statement : this.cleanPartitionFunctions()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsAssemblies()) {
            for (String statement : this.cleanAssemblies()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        if (this.supportsTypes()) {
            for (String statement : this.cleanTypes(schemas)) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
    }

    private List<String> cleanTypes(Schema[] schemas) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        String schemaList = Arrays.stream(schemas).map(s -> "'" + s.getName() + "'").collect(Collectors.joining(","));
        List<Map<String, String>> typesAndSchemas = this.jdbcTemplate.queryForList("SELECT t.name as type_name, s.name as schema_name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name IN (" + schemaList + ")", new Object[0]);
        for (Map<String, String> typeAndSchema : typesAndSchemas) {
            statements.add("DROP TYPE " + this.quote(typeAndSchema.get("schema_name"), typeAndSchema.get("type_name")));
        }
        return statements;
    }

    private List<String> cleanPartitionSchemes() throws SQLException {
        List<String> partitionSchemeNames = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.partition_schemes", new String[0]);
        ArrayList<String> statements = new ArrayList<String>();
        for (String partitionSchemeName : partitionSchemeNames) {
            statements.add("DROP PARTITION SCHEME " + this.quote(partitionSchemeName));
        }
        return statements;
    }

    private List<String> cleanAssemblies() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        List<String> assemblyNames = this.jdbcTemplate.queryForStringList("SELECT * FROM sys.assemblies WHERE is_user_defined=1", new String[0]);
        for (String assemblyName : assemblyNames) {
            statements.add("DROP ASSEMBLY " + this.quote(assemblyName));
        }
        return statements;
    }

    private List<String> cleanPartitionFunctions() throws SQLException {
        List<String> partitionFunctionNames = this.jdbcTemplate.queryForStringList("SELECT name FROM sys.partition_functions", new String[0]);
        ArrayList<String> statements = new ArrayList<String>();
        for (String partitionFunctionName : partitionFunctionNames) {
            statements.add("DROP PARTITION FUNCTION " + this.quote(partitionFunctionName));
        }
        return statements;
    }
}

