/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.output.InfoOutput;
import org.flywaydb.core.internal.output.MigrationOutput;

public class InfoOutputFactory {
    public InfoOutput create(Configuration configuration, MigrationInfo[] migrationInfos, MigrationInfo current) {
        String databaseName = "";
        try {
            databaseName = configuration.getDataSource().getConnection().getCatalog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set<MigrationVersion> undoableVersions = InfoOutputFactory.getUndoableVersions(migrationInfos);
        ArrayList<MigrationOutput> migrationOutputs = new ArrayList<MigrationOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            migrationOutputs.add(this.createMigrationOutput(undoableVersions, migrationInfo));
        }
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
        return new InfoOutput(schemaVersionToOutput.getVersion(), databaseName, currentSchemaVersion.getVersion(), this.join(", ", configuration.getSchemas()), migrationOutputs);
    }

    private MigrationOutput createMigrationOutput(Set<MigrationVersion> undoableVersions, MigrationInfo migrationInfo) {
        return new MigrationOutput(this.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toString() : "", migrationInfo.getState().getDisplayName(), InfoOutputFactory.getUndoableStatus(migrationInfo, undoableVersions), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", migrationInfo.getInstalledBy() != null ? migrationInfo.getInstalledBy() : "", migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    private String join(String joiner, String[] strings) {
        String output = "";
        if (strings.length == 1) {
            return strings[0];
        }
        for (String s : strings) {
            output = output + s + joiner;
        }
        return output;
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationVersion> undoableVersions) {
        return "";
    }

    private static Set<MigrationVersion> getUndoableVersions(MigrationInfo[] migrationInfos) {
        HashSet<MigrationVersion> result = new HashSet<MigrationVersion>();
        return result;
    }

    private static MigrationInfo[] removeAvailableUndos(MigrationInfo[] migrationInfos) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (migrationInfo.getState().equals((Object)MigrationState.AVAILABLE)) continue;
            result.add(migrationInfo);
        }
        return result.toArray(new MigrationInfo[0]);
    }

    private String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        return "Versioned";
    }
}

