/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.util.UUID;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class UUIDType
implements VariableType {
    public static final String TYPE_NAME = "uuid";
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        String textValue = valueFields.getTextValue();
        if (textValue == null) {
            return null;
        }
        return UUID.fromString(textValue);
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return UUID.class.isAssignableFrom(value.getClass());
    }
}

