/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class ShortType
implements VariableType {
    public static final String TYPE_NAME = "short";
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Short(valueFields.getLongValue().shortValue());
        }
        return null;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(Long.valueOf(((Short)value).longValue()));
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Short.class.isAssignableFrom(value.getClass()) || Short.TYPE.isAssignableFrom(value.getClass());
    }
}

