/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.dmn;

import org.flowable.app.engine.AppEngine;
import org.flowable.dmn.api.DmnDecisionService;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.flowable.dmn.spring.DmnEngineFactoryBean;
import org.flowable.dmn.spring.SpringDmnEngineConfiguration;
import org.flowable.engine.ProcessEngine;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnDmnEngine;
import org.flowable.spring.boot.dmn.DmnEngineAutoConfiguration;
import org.flowable.spring.boot.dmn.FlowableDmnProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnDmnEngine
@EnableConfigurationProperties(value={FlowableProperties.class, FlowableDmnProperties.class})
@AutoConfiguration(after={DmnEngineAutoConfiguration.class, AppEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
public class DmnEngineServicesAutoConfiguration {
    @Bean
    public DmnManagementService dmnManagementService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnManagementService();
    }

    @Bean
    public DmnRepositoryService dmnRepositoryService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnRepositoryService();
    }

    @Bean
    public DmnDecisionService dmnRuleService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnDecisionService();
    }

    @Bean
    public DmnHistoryService dmnHistoryService(DmnEngine dmnEngine) {
        return dmnEngine.getDmnHistoryService();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.dmn.engine.DmnEngine", "org.flowable.engine.ProcessEngine", "org.flowable.app.engine.AppEngine"})
    static class StandaloneEngineConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringDmnEngineConfiguration> {
        StandaloneEngineConfiguration() {
        }

        @Bean
        public DmnEngineFactoryBean dmnEngine(SpringDmnEngineConfiguration dmnEngineConfiguration) {
            DmnEngineFactoryBean factory = new DmnEngineFactoryBean();
            factory.setDmnEngineConfiguration((DmnEngineConfiguration)dmnEngineConfiguration);
            this.invokeConfigurers(dmnEngineConfiguration);
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.dmn.engine.DmnEngine"})
    @ConditionalOnBean(type={"org.flowable.app.engine.AppEngine"})
    static class AlreadyInitializedAppEngineConfiguration {
        AlreadyInitializedAppEngineConfiguration() {
        }

        @Bean
        public DmnEngine dmnEngine(AppEngine appEngine) {
            if (!DmnEngines.isInitialized()) {
                throw new IllegalStateException("DMN engine has not been initialized");
            }
            return DmnEngines.getDefaultDmnEngine();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(type={"org.flowable.dmn.engine.DmnEngine", "org.flowable.app.engine.AppEngine"})
    @ConditionalOnBean(type={"org.flowable.engine.ProcessEngine"})
    static class AlreadyInitializedEngineConfiguration {
        AlreadyInitializedEngineConfiguration() {
        }

        @Bean
        public DmnEngine dmnEngine(ProcessEngine processEngine) {
            if (!DmnEngines.isInitialized()) {
                throw new IllegalStateException("DMN engine has not been initialized");
            }
            return DmnEngines.getDefaultDmnEngine();
        }
    }
}

