/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import org.flowable.common.engine.api.identity.AuthenticationContext;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.spring.boot.ProcessEngineAutoConfiguration;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.security.FlowableUserDetailsService;
import org.flowable.spring.security.SpringSecurityAuthenticationContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AuthenticationManager.class, IdmIdentityService.class, FlowableUserDetailsService.class, GlobalAuthenticationConfigurerAdapter.class})
@ConditionalOnBean(value={IdmIdentityService.class})
@AutoConfigureBefore(value={SecurityAutoConfiguration.class})
@AutoConfigureAfter(value={IdmEngineServicesAutoConfiguration.class, ProcessEngineAutoConfiguration.class})
public class FlowableSecurityAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={UserDetailsService.class})
    public FlowableUserDetailsService flowableUserDetailsService(IdmIdentityService identityService) {
        return new FlowableUserDetailsService(identityService);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AuthenticationContext.class})
    public static class SpringSecurityAuthenticationContextConfiguration {
        public SpringSecurityAuthenticationContextConfiguration(ObjectProvider<AuthenticationContext> authenticationContext) {
            AuthenticationContext context = (AuthenticationContext)authenticationContext.getIfAvailable();
            if (context == null) {
                context = new SpringSecurityAuthenticationContext();
            }
            Authentication.setAuthenticationContext((AuthenticationContext)context);
        }
    }
}

