/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.mail.common.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentService;
import org.flowable.mail.common.api.MailMessage;
import org.flowable.mail.common.api.MailResponse;
import org.flowable.mail.common.api.SendMailRequest;
import org.flowable.mail.common.api.client.ExecutableSendMailRequest;
import org.flowable.mail.common.api.client.FlowableMailClient;
import org.flowable.mail.common.impl.FlowableMailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMailActivityDelegate<V extends VariableContainer> {
    private static final String NEWLINE_REGEX = "\\r?\\n";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Expression to;
    protected Expression from;
    protected Expression cc;
    protected Expression bcc;
    protected Expression headers;
    protected Expression subject;
    protected Expression text;
    protected Expression textVar;
    protected Expression html;
    protected Expression htmlVar;
    protected Expression charset;
    protected Expression ignoreException;
    protected Expression exceptionVariableName;
    protected Expression attachments;

    protected void prepareAndExecuteRequest(V variableContainer) {
        try {
            ExecutableSendMailRequest executableSendMailRequest = this.prepareRequest(variableContainer);
            executableSendMailRequest.send();
        }
        catch (FlowableMailException ex) {
            this.handleException(variableContainer, "Cannot send e-mail for " + variableContainer, ex);
        }
        catch (FlowableException ex) {
            this.handleException(variableContainer, ex.getMessage(), ex);
        }
    }

    protected ExecutableSendMailRequest prepareRequest(V variableContainer) {
        SendMailRequest request = this.createMailRequest(variableContainer);
        return this.getMailClient(variableContainer).prepareRequest(request);
    }

    protected SendMailRequest createMailRequest(V variableContainer) {
        return new SendMailRequest(this.createMessage(variableContainer));
    }

    protected abstract FlowableMailClient getMailClient(V var1);

    protected abstract Expression createExpression(String var1);

    protected abstract ContentService getContentService();

    protected MailMessage createMessage(V variableContainer) {
        String headersStr = this.getStringFromField(this.headers, variableContainer);
        Collection<String> toList = this.parseRecipients(this.to, variableContainer);
        String fromStr = this.getStringFromField(this.from, variableContainer);
        Collection<String> ccList = this.parseRecipients(this.cc, variableContainer);
        Collection<String> bccList = this.parseRecipients(this.bcc, variableContainer);
        String subjectStr = this.getStringFromField(this.subject, variableContainer);
        String textStr = this.textVar == null ? this.getStringFromField(this.text, variableContainer) : this.getStringFromField(this.getExpression(variableContainer, this.textVar), variableContainer);
        String htmlStr = this.htmlVar == null ? this.getStringFromField(this.html, variableContainer) : this.getStringFromField(this.getExpression(variableContainer, this.htmlVar), variableContainer);
        String charSetStr = this.getStringFromField(this.charset, variableContainer);
        if (toList.isEmpty() && ccList.isEmpty() && bccList.isEmpty()) {
            throw new FlowableException("No recipient could be found for sending email");
        }
        if (htmlStr == null && textStr == null) {
            throw new FlowableIllegalArgumentException("'html' or 'text' is required to be defined when using the mail activity");
        }
        MailMessage message = new MailMessage();
        this.addHeader(message, headersStr);
        message.setTo(toList);
        message.setFrom(fromStr);
        message.setCc(ccList);
        message.setBcc(bccList);
        message.setSubject(subjectStr);
        message.setPlainContent(textStr);
        message.setHtmlContent(htmlStr);
        if (charSetStr != null) {
            message.setCharset(Charset.forName(charSetStr));
        }
        this.addAttachments(message, variableContainer);
        return message;
    }

    protected void addHeader(MailMessage message, String headersStr) {
        if (headersStr == null) {
            return;
        }
        for (String headerEntry : headersStr.split(NEWLINE_REGEX)) {
            String[] split = headerEntry.split(":");
            if (split.length != 2) {
                throw new FlowableIllegalArgumentException("When using email headers name and value must be defined colon separated. (e.g. X-Attribute: value");
            }
            String name = split[0].trim();
            String value = split[1].trim();
            message.addHeader(name, value);
        }
    }

    protected void addAttachments(MailMessage message, V variableContainer) {
        if (this.attachments == null) {
            return;
        }
        Object value = this.attachments.getValue(variableContainer);
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (!collection.isEmpty()) {
                for (Object object : collection) {
                    this.addExpressionValueAttachment(message, object);
                }
            }
        } else {
            this.addExpressionValueAttachment(message, value);
        }
    }

    protected void addExpressionValueAttachment(MailMessage message, Object value) {
        if (value instanceof File) {
            File file = (File)value;
            if (this.fileExists(file)) {
                message.addAttachment((DataSource)new FileDataSource(file));
            }
        } else if (value instanceof String) {
            String filename = (String)value;
            File file = new File(filename);
            if (this.fileExists(file)) {
                message.addAttachment((DataSource)new FileDataSource(file));
            }
        } else if (value instanceof File[]) {
            File[] files;
            for (File file : files = (File[])value) {
                this.addExpressionValueAttachment(message, file);
            }
        } else if (value instanceof String[]) {
            String[] filenames;
            for (String filename : filenames = (String[])value) {
                this.addExpressionValueAttachment(message, filename);
            }
        } else if (value instanceof DataSource) {
            DataSource dataSource = (DataSource)value;
            message.addAttachment(dataSource);
        } else if (value instanceof DataSource[]) {
            DataSource[] dataSources;
            for (DataSource dataSource : dataSources = (DataSource[])value) {
                this.addExpressionValueAttachment(message, dataSource);
            }
        } else if (value instanceof ContentItem) {
            ContentItem contentItem = (ContentItem)value;
            message.addAttachment(new ContentItemDataSourceWrapper(contentItem, this.getContentService()));
        } else if (value instanceof ContentItem[]) {
            ContentItem[] contentItems;
            for (ContentItem contentItem : contentItems = (ContentItem[])value) {
                this.addExpressionValueAttachment(message, contentItem);
            }
        } else {
            throw new FlowableException("Invalid attachment type: " + value.getClass());
        }
    }

    protected String getStringFromField(Expression expression, V variableContainer) {
        Object value;
        if (expression != null && (value = expression.getValue(variableContainer)) != null) {
            return value.toString();
        }
        return null;
    }

    protected Collection<String> parseRecipients(Expression expression, V variableContainer) {
        if (expression == null) {
            return Collections.emptyList();
        }
        Object value = expression.getValue(variableContainer);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)value;
            ArrayList<String> recipients = new ArrayList<String>(arrayNode.size());
            for (JsonNode node : arrayNode) {
                recipients.add(node.asText());
            }
            return recipients;
        }
        String str = value.toString();
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            return Arrays.asList(value.toString().split("[\\s]*,[\\s]*"));
        }
        return Collections.emptyList();
    }

    protected boolean fileExists(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    protected Expression getExpression(V variableContainer, Expression var) {
        String variable = (String)variableContainer.getVariable(var.getExpressionText());
        return this.createExpression(variable);
    }

    protected void handleException(V variableContainer, String msg, FlowableException e) {
        boolean doIgnoreException = Boolean.parseBoolean(this.getStringFromField(this.ignoreException, variableContainer));
        if (doIgnoreException) {
            this.logger.info("Ignoring email send error: {}", (Object)msg, (Object)e);
            String exceptionVariable = this.getStringFromField(this.exceptionVariableName, variableContainer);
            if (exceptionVariable != null && exceptionVariable.length() > 0) {
                variableContainer.setVariable(exceptionVariable, (Object)msg);
            }
        } else {
            if (e instanceof FlowableMailException) {
                throw new FlowableException(msg, (Throwable)e);
            }
            throw e;
        }
    }

    public static class ContentItemDataSourceWrapper
    implements DataSource {
        protected final ContentItem contentItem;
        protected final ContentService contentService;

        public ContentItemDataSourceWrapper(ContentItem contentItem, ContentService contentService) {
            this.contentItem = contentItem;
            this.contentService = contentService;
        }

        public InputStream getInputStream() throws IOException {
            return this.contentService.getContentItemData(this.contentItem.getId());
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return this.contentItem.getMimeType();
        }

        public String getName() {
            return this.contentItem.getName();
        }
    }

    public record ExecutionData(MailResponse response, Throwable exception) {
    }
}

