/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl.spring.reactive;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.MultiValuePart;
import org.flowable.http.common.api.client.AsyncExecutableHttpRequest;
import org.flowable.http.common.api.client.FlowableAsyncHttpClient;
import org.flowable.http.common.impl.HttpClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public class SpringWebClientFlowableHttpClient
implements FlowableAsyncHttpClient {
    private static final Pattern PLUS_CHARACTER_PATTERN = Pattern.compile("\\+");
    private static final String ENCODED_PLUS_CHARACTER = "%2B";
    private static final Pattern SPACE_CHARACTER_PATTERN = Pattern.compile(" ");
    private static final String ENCODED_SPACE_CHARACTER = "%20";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final WebClient webClient;
    protected final Duration initialRequestTimeout;

    public SpringWebClientFlowableHttpClient(HttpClientConfig config) {
        HttpClient httpClient = HttpClient.create((ConnectionProvider)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"flowableHttpClient").maxConnections(500)).build()).compress(true);
        if (config.isDisableCertVerify()) {
            try {
                SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                httpClient = httpClient.secure(spec -> spec.sslContext(sslContext));
            }
            catch (Exception e) {
                this.logger.error("Could not configure HTTP Client SSL self signed strategy", (Throwable)e);
            }
        }
        httpClient = (HttpClient)((HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout())).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)config.getSocketTimeout(), TimeUnit.MILLISECONDS)));
        WebClient.Builder webClientBuilder = WebClient.builder();
        webClientBuilder = webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        this.webClient = webClientBuilder.build();
        this.initialRequestTimeout = Duration.ofMillis(config.getSocketTimeout());
    }

    public SpringWebClientFlowableHttpClient(WebClient.Builder builder) {
        this.webClient = builder.build();
        this.initialRequestTimeout = null;
    }

    @Override
    public AsyncExecutableHttpRequest prepareRequest(HttpRequest requestInfo) {
        try {
            URI uri = this.createUri(requestInfo.getUrl());
            WebClient.RequestHeadersSpec headersSpec = switch (requestInfo.getMethod()) {
                case "GET" -> this.webClient.get().uri(uri);
                case "POST" -> {
                    WebClient.RequestBodySpec post = (WebClient.RequestBodySpec)this.webClient.post().uri(uri);
                    this.setRequestEntity(requestInfo, post);
                    yield post;
                }
                case "PUT" -> {
                    WebClient.RequestBodySpec put = (WebClient.RequestBodySpec)this.webClient.put().uri(uri);
                    this.setRequestEntity(requestInfo, put);
                    yield put;
                }
                case "PATCH" -> {
                    WebClient.RequestBodySpec patch = (WebClient.RequestBodySpec)this.webClient.patch().uri(uri);
                    this.setRequestEntity(requestInfo, patch);
                    yield patch;
                }
                case "DELETE" -> {
                    WebClient.RequestBodySpec delete = (WebClient.RequestBodySpec)this.webClient.method(HttpMethod.DELETE).uri(uri);
                    this.setRequestEntity(requestInfo, delete);
                    yield delete;
                }
                case "HEAD" -> this.webClient.head().uri(uri);
                case "OPTIONS" -> this.webClient.options().uri(uri);
                default -> throw new FlowableException(requestInfo.getMethod() + " HTTP method not supported");
            };
            if (requestInfo.getHttpHeaders() != null) {
                this.setHeaders(headersSpec, requestInfo.getHttpHeaders());
            }
            return new WebClientExecutableHttpRequest(headersSpec);
        }
        catch (URISyntaxException ex) {
            throw new FlowableException("Invalid URL exception occurred", (Throwable)ex);
        }
    }

    protected WebClient determineWebClient(HttpRequest requestInfo) {
        if (requestInfo.getTimeout() <= 0) {
            return this.webClient;
        }
        Duration requestTimeout = Duration.ofMillis(requestInfo.getTimeout());
        if (requestTimeout.equals(this.initialRequestTimeout)) {
            return this.webClient;
        }
        return this.webClient.mutate().filter((request, next) -> next.exchange(request).timeout(requestTimeout)).build();
    }

    protected URI createUri(String url) throws URISyntaxException {
        String uri = SPACE_CHARACTER_PATTERN.matcher(url).replaceAll(ENCODED_SPACE_CHARACTER);
        return new URI(PLUS_CHARACTER_PATTERN.matcher(uri).replaceAll(ENCODED_PLUS_CHARACTER));
    }

    protected void setRequestEntity(HttpRequest requestInfo, WebClient.RequestBodySpec requestBodySpec) {
        if (requestInfo.getBody() != null) {
            if (StringUtils.isNotEmpty((CharSequence)requestInfo.getBodyEncoding())) {
                requestBodySpec.contentType(new MediaType(MediaType.TEXT_PLAIN, Charset.forName(requestInfo.getBodyEncoding())));
            }
            requestBodySpec.bodyValue((Object)requestInfo.getBody());
        } else if (requestInfo.getMultiValueParts() != null) {
            MultipartBodyBuilder multipartBodyBuilder = new MultipartBodyBuilder();
            for (MultiValuePart part : requestInfo.getMultiValueParts()) {
                String name = part.getName();
                Object value = part.getBody();
                if (value instanceof byte[]) {
                    value = new ByteArrayResourceWithFileName((byte[])value, part.getFilename());
                }
                MultipartBodyBuilder.PartBuilder partBuilder = multipartBodyBuilder.part(name, value);
                if (!StringUtils.isNotEmpty((CharSequence)part.getFilename())) continue;
                partBuilder.filename(part.getFilename());
            }
            requestBodySpec.body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)multipartBodyBuilder.build()));
        }
    }

    protected void setHeaders(WebClient.RequestHeadersSpec<?> base, org.flowable.http.common.api.HttpHeaders headers) {
        base.headers(httpHeaders -> httpHeaders.putAll((Map)headers));
    }

    protected HttpResponse toFlowableHttpResponse(ResponseEntity<ByteArrayResource> response) {
        HttpResponse responseInfo = new HttpResponse();
        HttpStatusCode statusCode = response.getStatusCode();
        responseInfo.setStatusCode(statusCode.value());
        if (statusCode instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)statusCode;
            responseInfo.setReason(httpStatus.getReasonPhrase());
        }
        responseInfo.setHttpHeaders(this.toFlowableHeaders(response.getHeaders()));
        ByteArrayResource body = (ByteArrayResource)response.getBody();
        if (body != null) {
            MediaType contentType = response.getHeaders().getContentType();
            byte[] bodyBytes = body.getByteArray();
            if (contentType != null && contentType.getCharset() != null) {
                responseInfo.setBody(new String(bodyBytes, contentType.getCharset()));
            } else {
                responseInfo.setBody(new String(bodyBytes));
            }
            responseInfo.setBodyBytes(bodyBytes);
        }
        return responseInfo;
    }

    protected org.flowable.http.common.api.HttpHeaders toFlowableHeaders(HttpHeaders httpHeaders) {
        org.flowable.http.common.api.HttpHeaders headers = new org.flowable.http.common.api.HttpHeaders();
        headers.putAll((Map<? extends String, ? extends List<String>>)httpHeaders);
        return headers;
    }

    protected class WebClientExecutableHttpRequest
    implements AsyncExecutableHttpRequest {
        protected final WebClient.RequestHeadersSpec<?> request;

        public WebClientExecutableHttpRequest(WebClient.RequestHeadersSpec<?> request) {
            this.request = request;
        }

        @Override
        public CompletableFuture<HttpResponse> callAsync() {
            return this.request.exchangeToMono(response -> response.toEntity(ByteArrayResource.class)).map(SpringWebClientFlowableHttpClient.this::toFlowableHttpResponse).toFuture();
        }
    }

    protected static class ByteArrayResourceWithFileName
    extends ByteArrayResource {
        protected final String filename;

        public ByteArrayResourceWithFileName(byte[] byteArray, String filename) {
            super(byteArray);
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

