/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.model;

import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.model.OutboundChannelModelBuilder;
import org.flowable.eventregistry.json.converter.ChannelJsonConverter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionOutboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.model.KafkaOutboundChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;

public class OutboundChannelDefinitionBuilderImpl
implements OutboundChannelModelBuilder {
    protected EventRepositoryService eventRepository;
    protected ChannelJsonConverter channelJsonConverter;
    protected OutboundChannelModel channelDefinition;
    protected String deploymentName;
    protected String resourceName;
    protected String category;
    protected String parentDeploymentId;
    protected String deploymentTenantId;
    protected String key;

    public OutboundChannelDefinitionBuilderImpl(EventRepositoryService eventRepository, ChannelJsonConverter channelJsonConverter) {
        this.eventRepository = eventRepository;
        this.channelJsonConverter = channelJsonConverter;
    }

    public OutboundChannelModelBuilder key(String key) {
        this.key = key;
        return this;
    }

    public OutboundChannelModelBuilder deploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public OutboundChannelModelBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public OutboundChannelModelBuilder category(String category) {
        this.category = category;
        return this;
    }

    public OutboundChannelModelBuilder parentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
        return this;
    }

    public OutboundChannelModelBuilder deploymentTenantId(String deploymentTenantId) {
        this.deploymentTenantId = deploymentTenantId;
        return this;
    }

    public OutboundChannelModelBuilder.OutboundEventProcessingPipelineBuilder channelAdapter(String delegateExpression) {
        DelegateExpressionOutboundChannelModel channelDefinition = new DelegateExpressionOutboundChannelModel();
        channelDefinition.setAdapterDelegateExpression(delegateExpression);
        this.channelDefinition = channelDefinition;
        return new OutboundEventProcessingPipelineBuilderImpl(this, (OutboundChannelModel)channelDefinition);
    }

    public OutboundChannelModelBuilder.OutboundJmsChannelBuilder jmsChannelAdapter(String destination) {
        JmsOutboundChannelModel channelDefinition = new JmsOutboundChannelModel();
        channelDefinition.setDestination(destination);
        this.channelDefinition = channelDefinition;
        this.channelDefinition.setKey(this.key);
        return new OutboundJmsChannelBuilderImpl(this.eventRepository, this, channelDefinition);
    }

    public OutboundChannelModelBuilder.OutboundRabbitChannelBuilder rabbitChannelAdapter(String routingKey) {
        RabbitOutboundChannelModel channelDefinition = new RabbitOutboundChannelModel();
        channelDefinition.setRoutingKey(routingKey);
        this.channelDefinition = channelDefinition;
        this.channelDefinition.setKey(this.key);
        return new OutboundRabbitChannelBuilderImpl(this.eventRepository, this, channelDefinition);
    }

    public OutboundChannelModelBuilder.OutboundKafkaChannelBuilder kafkaChannelAdapter(String topic) {
        KafkaOutboundChannelModel channelDefinition = new KafkaOutboundChannelModel();
        channelDefinition.setTopic(topic);
        this.channelDefinition = channelDefinition;
        this.channelDefinition.setKey(this.key);
        return new OutboundKafkaChannelBuilderImpl(this.eventRepository, this, channelDefinition);
    }

    public EventDeployment deploy() {
        if (this.resourceName == null) {
            this.resourceName = "outbound-" + this.key + ".channel";
        }
        OutboundChannelModel channelModel = this.buildChannelModel();
        EventDeployment eventDeployment = this.eventRepository.createDeployment().name(this.deploymentName).addChannelDefinition(this.resourceName, this.channelJsonConverter.convertToJson((ChannelModel)channelModel)).category(this.category).parentDeploymentId(this.parentDeploymentId).tenantId(this.deploymentTenantId).deploy();
        return eventDeployment;
    }

    public OutboundChannelModel buildChannelModel() {
        OutboundChannelModel outboundChannelModel = this.channelDefinition == null ? new OutboundChannelModel() : this.channelDefinition;
        outboundChannelModel.setKey(this.key);
        return outboundChannelModel;
    }

    public static class OutboundEventProcessingPipelineBuilderImpl
    implements OutboundChannelModelBuilder.OutboundEventProcessingPipelineBuilder {
        protected OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder;
        protected OutboundChannelModel outboundChannel;

        public OutboundEventProcessingPipelineBuilderImpl(OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder, OutboundChannelModel outboundChannel) {
            this.outboundChannelDefinitionBuilder = outboundChannelDefinitionBuilder;
            this.outboundChannel = outboundChannel;
        }

        public OutboundChannelModelBuilder jsonSerializer() {
            this.outboundChannel.setSerializerType("json");
            return this.outboundChannelDefinitionBuilder;
        }

        public OutboundChannelModelBuilder xmlSerializer() {
            this.outboundChannel.setSerializerType("xml");
            return this.outboundChannelDefinitionBuilder;
        }

        public OutboundChannelModelBuilder delegateExpressionSerializer(String delegateExpression) {
            this.outboundChannel.setSerializerType("expression");
            this.outboundChannel.setSerializerDelegateExpression(delegateExpression);
            return this.outboundChannelDefinitionBuilder;
        }

        public OutboundChannelModelBuilder eventProcessingPipeline(String delegateExpression) {
            this.outboundChannel.setPipelineDelegateExpression(delegateExpression);
            return this.outboundChannelDefinitionBuilder;
        }
    }

    public static class OutboundKafkaChannelBuilderImpl
    implements OutboundChannelModelBuilder.OutboundKafkaChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder;
        protected KafkaOutboundChannelModel kafkaChannel;

        public OutboundKafkaChannelBuilderImpl(EventRepositoryService eventRepositoryService, OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder, KafkaOutboundChannelModel kafkaChannel) {
            this.eventRepositoryService = eventRepositoryService;
            this.outboundChannelDefinitionBuilder = outboundChannelDefinitionBuilder;
            this.kafkaChannel = kafkaChannel;
        }

        public OutboundChannelModelBuilder.OutboundKafkaChannelBuilder recordKey(String key) {
            this.kafkaChannel.setRecordKey(key);
            return this;
        }

        public OutboundChannelModelBuilder.OutboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            return new OutboundEventProcessingPipelineBuilderImpl(this.outboundChannelDefinitionBuilder, (OutboundChannelModel)this.kafkaChannel);
        }
    }

    public static class OutboundRabbitChannelBuilderImpl
    implements OutboundChannelModelBuilder.OutboundRabbitChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder;
        protected RabbitOutboundChannelModel rabbitChannel;

        public OutboundRabbitChannelBuilderImpl(EventRepositoryService eventRepositoryService, OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder, RabbitOutboundChannelModel rabbitChannel) {
            this.eventRepositoryService = eventRepositoryService;
            this.outboundChannelDefinitionBuilder = outboundChannelDefinitionBuilder;
            this.rabbitChannel = rabbitChannel;
        }

        public OutboundChannelModelBuilder.OutboundRabbitChannelBuilder exchange(String exchange) {
            this.rabbitChannel.setExchange(exchange);
            return this;
        }

        public OutboundChannelModelBuilder.OutboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            return new OutboundEventProcessingPipelineBuilderImpl(this.outboundChannelDefinitionBuilder, (OutboundChannelModel)this.rabbitChannel);
        }
    }

    public static class OutboundJmsChannelBuilderImpl
    implements OutboundChannelModelBuilder.OutboundJmsChannelBuilder {
        protected final EventRepositoryService eventRepositoryService;
        protected final OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder;
        protected JmsOutboundChannelModel jmsChannel;

        public OutboundJmsChannelBuilderImpl(EventRepositoryService eventRepositoryService, OutboundChannelDefinitionBuilderImpl outboundChannelDefinitionBuilder, JmsOutboundChannelModel jmsChannel) {
            this.eventRepositoryService = eventRepositoryService;
            this.outboundChannelDefinitionBuilder = outboundChannelDefinitionBuilder;
            this.jmsChannel = jmsChannel;
        }

        public OutboundChannelModelBuilder.OutboundEventProcessingPipelineBuilder eventProcessingPipeline() {
            return new OutboundEventProcessingPipelineBuilderImpl(this.outboundChannelDefinitionBuilder, (OutboundChannelModel)this.jmsChannel);
        }
    }
}

