/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.flowable.eventregistry.api.InboundEvent;

public class KafkaConsumerRecordInboundEvent
implements InboundEvent {
    protected final ConsumerRecord<?, ?> consumerRecord;
    protected Map<String, Object> headers;

    public KafkaConsumerRecordInboundEvent(ConsumerRecord<?, ?> consumerRecord) {
        this.consumerRecord = consumerRecord;
    }

    public Object getRawEvent() {
        return this.consumerRecord;
    }

    public Object getBody() {
        return this.consumerRecord.value();
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.retrieveHeaders();
        }
        return this.headers;
    }

    protected Map<String, Object> retrieveHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Headers consumerRecordHeaders = this.consumerRecord.headers();
        for (Header consumerRecordHeader : consumerRecordHeaders) {
            headers.put(consumerRecordHeader.key(), consumerRecordHeader.value());
        }
        return headers;
    }

    public String toString() {
        return "KafkaConsumerRecordInboundEvent{consumerRecord=" + this.consumerRecord + ", headers=" + this.headers + "}";
    }
}

