/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;

public class EventPayload {
    protected String name;
    protected String type;
    protected boolean header;
    protected boolean correlationParameter;
    protected boolean isFullPayload;
    protected boolean metaParameter;

    public EventPayload() {
    }

    public EventPayload(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public static EventPayload header(String name, String type) {
        EventPayload payload = new EventPayload(name, type);
        payload.setHeader(true);
        return payload;
    }

    public static EventPayload headerWithCorrelation(String name, String type) {
        EventPayload payload = new EventPayload(name, type);
        payload.setHeader(true);
        payload.setCorrelationParameter(true);
        return payload;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isCorrelationParameter() {
        return this.correlationParameter;
    }

    public void setCorrelationParameter(boolean correlationParameter) {
        this.correlationParameter = correlationParameter;
    }

    public static EventPayload correlation(String name, String type) {
        EventPayload payload = new EventPayload(name, type);
        payload.setCorrelationParameter(true);
        return payload;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isFullPayload() {
        return this.isFullPayload;
    }

    public void setFullPayload(boolean isFullPayload) {
        this.isFullPayload = isFullPayload;
    }

    public static EventPayload fullPayload(String name) {
        EventPayload payload = new EventPayload();
        payload.name = name;
        payload.setFullPayload(true);
        return payload;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isMetaParameter() {
        return this.metaParameter;
    }

    public void setMetaParameter(boolean metaParameter) {
        this.metaParameter = metaParameter;
    }

    @JsonIgnore
    public boolean isNotForBody() {
        return this.header || this.isFullPayload || this.metaParameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventPayload that = (EventPayload)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && this.correlationParameter == that.correlationParameter && this.header == that.header && this.isFullPayload == that.isFullPayload && this.metaParameter == that.metaParameter;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }
}

