/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.util.function.Consumer;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.impl.test.InternalFlowableExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ResourceFlowableExtension
extends InternalFlowableExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ResourceFlowableExtension.class});
    protected final String configurationResource;
    protected final String processEngineName;
    protected final Consumer<ProcessEngineConfiguration> configurationConsumer;

    public ResourceFlowableExtension(String configurationResource, Consumer<ProcessEngineConfiguration> configurationConsumer) {
        this(configurationResource, null, configurationConsumer);
    }

    public ResourceFlowableExtension(String configurationResource, String processEngineName, Consumer<ProcessEngineConfiguration> configurationConsumer) {
        this.configurationResource = configurationResource;
        this.processEngineName = processEngineName;
        this.configurationConsumer = configurationConsumer;
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        super.afterEach(context);
        ProcessEngine processEngine = this.getProcessEngine(context);
        processEngine.close();
        processEngine = null;
    }

    @Override
    protected ProcessEngine getProcessEngine(ExtensionContext context) {
        return (ProcessEngine)this.getStore(context).getOrComputeIfAbsent((Object)context.getUniqueId(), key -> this.initializeProcessEngine(), ProcessEngine.class);
    }

    protected ProcessEngine initializeProcessEngine() {
        ProcessEngineConfiguration config = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(this.configurationResource);
        if (this.processEngineName != null) {
            this.logger.info("Initializing process engine with name '{}'", (Object)this.processEngineName);
            config.setEngineName(this.processEngineName);
        }
        this.configurationConsumer.accept(config);
        ProcessEngine processEngine = config.buildProcessEngine();
        ProcessEngines.setInitialized(true);
        return processEngine;
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    public ProcessEngine rebootEngine() {
        String engineName = this.processEngineName != null ? this.processEngineName : "default";
        ProcessEngine processEngine = ProcessEngines.getProcessEngine(engineName);
        ProcessEngines.unregister(processEngine);
        return this.initializeProcessEngine();
    }
}

