/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobCompatibilityManager;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;

public class DefaultInternalJobCompatibilityManager
implements InternalJobCompatibilityManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultInternalJobCompatibilityManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public boolean isFlowable5Job(Job job) {
        if (job.getProcessDefinitionId() != null) {
            return Flowable5Util.isFlowable5ProcessDefinitionId(this.processEngineConfiguration, job.getProcessDefinitionId());
        }
        return false;
    }

    public void executeV5Job(Job job) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.executeJob(job);
    }

    public void executeV5JobWithLockAndRetry(final Job job) {
        this.processEngineConfiguration.getCommandExecutor().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().executeJobWithLockAndRetry(job);
                return null;
            }
        });
    }

    public void deleteV5Job(String jobId) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.deleteJob(jobId);
    }

    public void handleFailedV5Job(AbstractRuntimeJobEntity job, Throwable exception) {
        Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
        compatibilityHandler.handleFailedJob((Job)job, exception);
    }
}

