/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.configurator;

import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.AbstractEngineConfigurator;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.configurator.impl.deployer.BpmnDeployer;
import org.flowable.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.flowable.engine.impl.db.EntityDependencyOrder;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityImpl;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayEntityImpl;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntityImpl;

public class ProcessEngineConfigurator
extends AbstractEngineConfigurator {
    protected ProcessEngineConfiguration processEngineConfiguration;

    public int getPriority() {
        return 50000;
    }

    protected List<EngineDeployer> getCustomDeployers() {
        return Collections.singletonList(new BpmnDeployer());
    }

    protected String getMybatisCfgPath() {
        return "org/flowable/db/mapping/mappings.xml";
    }

    public void configure(AbstractEngineConfiguration engineConfiguration) {
        if (this.processEngineConfiguration == null) {
            this.processEngineConfiguration = new StandaloneProcessEngineConfiguration();
        }
        this.initialiseCommonProperties(engineConfiguration, (AbstractEngineConfiguration)this.processEngineConfiguration);
        this.initProcessEngine();
        this.initServiceConfigurations(engineConfiguration, (AbstractEngineConfiguration)this.processEngineConfiguration);
    }

    protected void initDbSqlSessionFactory(AbstractEngineConfiguration engineConfiguration, AbstractEngineConfiguration targetEngineConfiguration) {
        DbSqlSessionFactory dbSqlSessionFactory = engineConfiguration.getDbSqlSessionFactory();
        targetEngineConfiguration.setDbSqlSessionFactory(engineConfiguration.getDbSqlSessionFactory());
        targetEngineConfiguration.setSqlSessionFactory(engineConfiguration.getSqlSessionFactory());
        if (this.getEntityInsertionOrder() != null) {
            dbSqlSessionFactory.getInsertionOrder().remove(IdentityLinkEntityImpl.class);
            dbSqlSessionFactory.getInsertionOrder().remove(VariableInstanceEntityImpl.class);
            dbSqlSessionFactory.getInsertionOrder().remove(VariableByteArrayEntityImpl.class);
            for (Class<? extends Entity> clazz : this.getEntityInsertionOrder()) {
                dbSqlSessionFactory.getInsertionOrder().add(clazz);
            }
        }
        if (this.getEntityDeletionOrder() != null) {
            dbSqlSessionFactory.getDeletionOrder().remove(IdentityLinkEntityImpl.class);
            dbSqlSessionFactory.getDeletionOrder().remove(VariableInstanceEntityImpl.class);
            dbSqlSessionFactory.getDeletionOrder().remove(VariableByteArrayEntityImpl.class);
            for (Class<? extends Entity> clazz : this.getEntityDeletionOrder()) {
                dbSqlSessionFactory.getDeletionOrder().add(clazz);
            }
        }
    }

    protected List<Class<? extends Entity>> getEntityInsertionOrder() {
        return EntityDependencyOrder.INSERT_ORDER;
    }

    protected List<Class<? extends Entity>> getEntityDeletionOrder() {
        return EntityDependencyOrder.DELETE_ORDER;
    }

    protected synchronized ProcessEngine initProcessEngine() {
        if (this.processEngineConfiguration == null) {
            throw new FlowableException("ProcessEngineConfiguration is required");
        }
        return this.processEngineConfiguration.buildProcessEngine();
    }

    public ProcessEngineConfiguration getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public ProcessEngineConfigurator setProcessEngineConfiguration(ProcessEngineConfiguration processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        return this;
    }
}

