/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.event.FlowableCmmnEventBuilder;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
implements Command<Void> {
    protected String taskId;
    protected String userId;
    protected Map<String, Object> variables;
    protected Map<String, Object> variablesLocal;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> transientVariablesLocal;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.taskId = taskId;
        this.variables = variables;
        this.transientVariables = transientVariables;
    }

    public CompleteTaskCmd(String taskId, String userId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables, transientVariables);
        this.userId = userId;
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> variablesLocal, Map<String, Object> transientVariables, Map<String, Object> transientVariablesLocal) {
        this(taskId, variables, transientVariables);
        this.variablesLocal = variablesLocal;
        this.transientVariablesLocal = transientVariablesLocal;
    }

    public CompleteTaskCmd(String taskId, String userId, Map<String, Object> variables, Map<String, Object> variablesLocal, Map<String, Object> transientVariables, Map<String, Object> transientVariablesLocal) {
        this(taskId, variables, variablesLocal, transientVariables, transientVariablesLocal);
        this.userId = userId;
    }

    public Void execute(CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher;
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("Null task id");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        TaskEntity taskEntity = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(this.taskId);
        if (taskEntity == null) {
            throw new FlowableObjectNotFoundException("Could not find task entity for id " + this.taskId, TaskEntity.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)taskEntity.getProcessInstanceId())) {
            throw new FlowableException(taskEntity + " is created by the process engine and should be completed via the process engine API");
        }
        String planItemInstanceId = taskEntity.getSubScopeId();
        PlanItemInstanceEntity planItemInstanceEntity = null;
        if (planItemInstanceId != null && (planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceId)) == null) {
            throw new FlowableException("Could not find plan item instance for " + taskEntity);
        }
        if (this.variables != null) {
            taskEntity.setVariables(this.variables);
        }
        if (this.variablesLocal != null) {
            taskEntity.setVariablesLocal(this.variablesLocal);
        }
        if (this.transientVariables != null) {
            taskEntity.setTransientVariables(this.transientVariables);
        }
        if (this.transientVariablesLocal != null) {
            taskEntity.setTransientVariablesLocal(this.transientVariablesLocal);
        }
        TaskHelper.logUserTaskCompleted(taskEntity, cmmnEngineConfiguration);
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleCompleteTask(taskEntity);
        }
        if ((eventDispatcher = cmmnEngineConfiguration.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableCmmnEventBuilder.createTaskCompletedEvent((Task)taskEntity), cmmnEngineConfiguration.getEngineCfgKey());
        }
        cmmnEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (planItemInstanceEntity != null) {
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                String taskLabel = null;
                taskLabel = StringUtils.isNotEmpty((CharSequence)taskEntity.getName()) ? taskEntity.getName() : taskEntity.getId();
                CmmnLoggingSessionUtil.addLoggingData("humanTaskComplete", "Human task '" + taskLabel + "' completed", taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
            if (this.userId != null) {
                taskEntity.setTempCompletedBy(this.userId);
            }
            CommandContextUtil.getAgenda(commandContext).planTriggerPlanItemInstanceOperation(planItemInstanceEntity);
        } else {
            TaskHelper.completeTask(taskEntity, this.userId, cmmnEngineConfiguration);
        }
        if (cmmnEngineConfiguration.getHumanTaskStateInterceptor() != null) {
            cmmnEngineConfiguration.getHumanTaskStateInterceptor().handleComplete(taskEntity, this.userId);
        }
        return null;
    }
}

