/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableTaskAlreadyClaimedException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class ClaimTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public ClaimTaskCmd(String taskId, String userId) {
        super(taskId);
        this.userId = userId;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (this.userId != null) {
            Clock clock = cmmnEngineConfiguration.getClock();
            task.setClaimTime(clock.getCurrentTime());
            task.setClaimedBy(this.userId);
            task.setState("claimed");
            if (task.getAssignee() != null) {
                if (!task.getAssignee().equals(this.userId)) {
                    throw new FlowableTaskAlreadyClaimedException(task.getId(), task.getAssignee());
                }
                cmmnEngineConfiguration.getCmmnHistoryManager().recordTaskInfoChange(task, clock.getCurrentTime());
            } else {
                TaskHelper.changeTaskAssignee(task, this.userId, cmmnEngineConfiguration);
                if (cmmnEngineConfiguration.getHumanTaskStateInterceptor() != null) {
                    cmmnEngineConfiguration.getHumanTaskStateInterceptor().handleClaim(task, this.userId);
                }
            }
        } else if (task.getAssignee() != null) {
            task.setClaimTime(null);
            task.setClaimedBy(null);
            if (task.getInProgressStartTime() != null) {
                task.setState("inProgress");
            } else {
                task.setState("created");
            }
            TaskHelper.changeTaskAssignee(task, null, cmmnEngineConfiguration);
            if (cmmnEngineConfiguration.getHumanTaskStateInterceptor() != null) {
                cmmnEngineConfiguration.getHumanTaskStateInterceptor().handleUnclaim(task, this.userId);
            }
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskExceptionPrefix() {
        return "Cannot claim";
    }
}

