/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator.impl.cmmn;

import java.util.Map;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.engine.impl.cmmn.CaseInstanceService;

public class DefaultCaseInstanceService
implements CaseInstanceService {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCaseInstanceService(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String startCaseInstanceByKey(String caseDefinitionKey, String caseInstanceName, String businessKey, String executionId, String tenantId, boolean fallbackToDefaultTenant, Map<String, Object> inParametersMap) {
        CaseInstanceBuilder caseInstanceBuilder = this.cmmnEngineConfiguration.getCmmnRuntimeService().createCaseInstanceBuilder();
        caseInstanceBuilder.caseDefinitionKey(caseDefinitionKey);
        if (tenantId != null) {
            caseInstanceBuilder.tenantId(tenantId);
        }
        if (executionId != null) {
            caseInstanceBuilder.callbackId(executionId);
            caseInstanceBuilder.callbackType("bpmn-2.0-to-cmmn-1.1-child-case");
        }
        for (String target : inParametersMap.keySet()) {
            caseInstanceBuilder.variable(target, inParametersMap.get(target));
        }
        if (fallbackToDefaultTenant) {
            caseInstanceBuilder.fallbackToDefaultTenant();
        }
        CaseInstance caseInstance = caseInstanceBuilder.start();
        return caseInstance.getId();
    }

    public void deleteCaseInstance(String caseInstanceId) {
        this.cmmnEngineConfiguration.getCmmnRuntimeService().terminateCaseInstance(caseInstanceId);
    }
}

