/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.util;

import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryOnPart;

public class PlanItemDependencyUtil {
    public static List<PlanItem> getEntryDependencies(PlanItem planItem) {
        return PlanItemDependencyUtil.getSourcePlanItems(planItem.getEntryCriteria());
    }

    public static List<PlanItem> getExitDependencies(PlanItem planItem) {
        return PlanItemDependencyUtil.getSourcePlanItems(planItem.getExitCriteria());
    }

    protected static List<PlanItem> getSourcePlanItems(List<Criterion> criteria) {
        ArrayList<PlanItem> planItems = new ArrayList<PlanItem>();
        if (!criteria.isEmpty()) {
            for (Criterion entryCriterion : criteria) {
                Sentry sentry = entryCriterion.getSentry();
                if (sentry.getOnParts() == null || sentry.getOnParts().isEmpty()) continue;
                for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
                    planItems.add(sentryOnPart.getSource());
                }
            }
        }
        return planItems;
    }

    public static boolean isEntryDependency(PlanItem planItem, PlanItem dependency) {
        for (PlanItem entryDependency : planItem.getEntryDependencies()) {
            if (!entryDependency.getId().equals(dependency.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExitDependency(PlanItem planItem, PlanItem dependency) {
        for (PlanItem exitDependency : planItem.getExitDependencies()) {
            if (!exitDependency.getId().equals(dependency.getId())) continue;
            return true;
        }
        return false;
    }
}

