/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ValuedDataObject;

public class JsonDataObject
extends ValuedDataObject {
    @Override
    public void setValue(Object value) {
        if (value instanceof String && !StringUtils.isEmpty((CharSequence)((String)value).trim())) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.value = mapper.readTree((String)value);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid JSON expression to parse", e);
            }
        } else if (value instanceof JsonNode) {
            this.value = value;
        } else {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true));
            this.value = mapper.convertValue(value, JsonNode.class);
        }
    }

    @Override
    public JsonDataObject clone() {
        JsonDataObject clone = new JsonDataObject();
        clone.setValues(this);
        return clone;
    }
}

