/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring.autodeployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipInputStream;
import org.flowable.app.api.repository.AppDeploymentBuilder;
import org.flowable.app.engine.AppEngine;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public abstract class AbstractAppAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<AppEngine> {
    public AbstractAppAutoDeploymentStrategy() {
    }

    public AbstractAppAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(AppEngine engine, String deploymentNameHint) {
        return engine.getAppEngineConfiguration().getLockManager(this.determineLockName("appDeploymentsLock"));
    }

    protected void addResource(Resource resource, AppDeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, AppDeploymentBuilder deploymentBuilder) {
        block14: {
            try (InputStream inputStream = resource.getInputStream();){
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip")) {
                    try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
                        deploymentBuilder.addZipInputStream(zipStream);
                        break block14;
                    }
                }
                deploymentBuilder.addInputStream(resourceName, inputStream);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read resource " + resource, ex);
            }
        }
    }
}

