/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.GeneratedKeysQueryBuilder;
import org.firebirdsql.jdbc.GeneratedKeysSupport;

final class GeneratedKeysSupportFactory {
    static final String REASON_NO_RETURNING_SUPPORT = "This version of Firebird does not support retrieving generated keys (support was added in Firebird 2.0)";
    static final String REASON_EXPLICITLY_DISABLED = "disabled through connection property";
    private static final String GENERATED_KEYS_ENABLED_DEFAULT = "default";
    private static final String GENERATED_KEYS_DISABLED = "disabled";
    private static final String GENERATED_KEYS_IGNORED = "ignored";

    private GeneratedKeysSupportFactory() {
    }

    static GeneratedKeysSupport createFor(String generatedKeysEnabled, FirebirdDatabaseMetaData fbDatabaseMetaData) throws SQLException {
        String normalizedConfigValue;
        String string = normalizedConfigValue = generatedKeysEnabled != null && !generatedKeysEnabled.isEmpty() ? generatedKeysEnabled.toLowerCase(Locale.ROOT) : GENERATED_KEYS_ENABLED_DEFAULT;
        if (GENERATED_KEYS_DISABLED.equals(normalizedConfigValue)) {
            return DisabledGeneratedKeysSupport.EXPLICITLY_DISABLED;
        }
        if (GENERATED_KEYS_IGNORED.equals(normalizedConfigValue)) {
            return IgnoredGeneratedKeysSupport.INSTANCE;
        }
        Set<GeneratedKeysSupport.QueryType> returningSupport = GeneratedKeysSupport.QueryType.returningSupportForVersion(fbDatabaseMetaData.getDatabaseMajorVersion(), fbDatabaseMetaData.getDatabaseMinorVersion());
        if (returningSupport.isEmpty()) {
            return new DisabledGeneratedKeysSupport(REASON_NO_RETURNING_SUPPORT);
        }
        if (GENERATED_KEYS_ENABLED_DEFAULT.equals(normalizedConfigValue)) {
            return new DefaultGeneratedKeysSupport(fbDatabaseMetaData, returningSupport);
        }
        Set<GeneratedKeysSupport.QueryType> enabledTypes = GeneratedKeysSupportFactory.getEnabledTypes(normalizedConfigValue, returningSupport);
        if (enabledTypes.isEmpty()) {
            return IgnoredGeneratedKeysSupport.INSTANCE;
        }
        return new DefaultGeneratedKeysSupport(fbDatabaseMetaData, enabledTypes);
    }

    private static Set<GeneratedKeysSupport.QueryType> getEnabledTypes(String normalizedConfigValue, Set<GeneratedKeysSupport.QueryType> returningSupport) {
        String[] queryTypeNames = normalizedConfigValue.split(",");
        EnumSet<GeneratedKeysSupport.QueryType> enabledTypes = EnumSet.noneOf(GeneratedKeysSupport.QueryType.class);
        for (String queryTypeName : queryTypeNames) {
            for (GeneratedKeysSupport.QueryType queryType : returningSupport) {
                if (!queryType.matches(queryTypeName.trim())) continue;
                enabledTypes.add(queryType);
            }
        }
        return enabledTypes;
    }

    private static final class IgnoredGeneratedKeysSupport
    implements GeneratedKeysSupport {
        private static final IgnoredGeneratedKeysSupport INSTANCE = new IgnoredGeneratedKeysSupport();

        private IgnoredGeneratedKeysSupport() {
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int autoGeneratedKeys) {
            return this.createNonGeneratedKeysQuery(sql);
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int[] columnIndexes) {
            return this.createNonGeneratedKeysQuery(sql);
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, String[] columnNames) {
            return this.createNonGeneratedKeysQuery(sql);
        }

        @Override
        public Set<GeneratedKeysSupport.QueryType> supportedQueryTypes() {
            return Collections.emptySet();
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return false;
        }

        private GeneratedKeysSupport.Query createNonGeneratedKeysQuery(String sql) {
            return new GeneratedKeysSupport.Query(false, sql);
        }
    }

    private static final class DisabledGeneratedKeysSupport
    implements GeneratedKeysSupport {
        private static final DisabledGeneratedKeysSupport EXPLICITLY_DISABLED = new DisabledGeneratedKeysSupport("disabled through connection property");
        private final String reasonDisabled;

        public DisabledGeneratedKeysSupport(String reasonDisabled) {
            this.reasonDisabled = reasonDisabled;
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int autoGeneratedKeys) throws SQLException {
            switch (autoGeneratedKeys) {
                case 2: {
                    return new GeneratedKeysSupport.Query(false, sql);
                }
                case 1: {
                    throw this.disabled();
                }
            }
            throw new FbExceptionBuilder().nonTransientException(337248288).toSQLException();
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int[] columnIndexes) throws SQLException {
            throw this.disabled();
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, String[] columnNames) throws SQLException {
            throw this.disabled();
        }

        @Override
        public Set<GeneratedKeysSupport.QueryType> supportedQueryTypes() {
            return Collections.emptySet();
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return false;
        }

        private SQLException disabled() {
            return FbExceptionBuilder.forException(337248289).messageParameter(this.reasonDisabled).toSQLException();
        }
    }

    private static final class DefaultGeneratedKeysSupport
    implements GeneratedKeysSupport {
        private final FirebirdDatabaseMetaData fbDatabaseMetaData;
        private final Set<GeneratedKeysSupport.QueryType> supportedQueryTypes;

        private DefaultGeneratedKeysSupport(FirebirdDatabaseMetaData fbDatabaseMetaData, Set<GeneratedKeysSupport.QueryType> supportedQueryTypes) {
            assert (!supportedQueryTypes.contains((Object)GeneratedKeysSupport.QueryType.UNSUPPORTED)) : "supportedQueryTypes should not contain UNSUPPORTED";
            assert (!supportedQueryTypes.isEmpty()) : "At least one query type should be present";
            this.fbDatabaseMetaData = fbDatabaseMetaData;
            this.supportedQueryTypes = supportedQueryTypes;
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int autoGeneratedKeys) throws SQLException {
            switch (autoGeneratedKeys) {
                case 2: {
                    return GeneratedKeysQueryBuilder.create(sql, this.supportedQueryTypes).forNoGeneratedKeysOption();
                }
                case 1: {
                    return GeneratedKeysQueryBuilder.create(sql, this.supportedQueryTypes).forReturnGeneratedKeysOption(this.fbDatabaseMetaData);
                }
            }
            throw new FbExceptionBuilder().nonTransientException(337248288).toSQLException();
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, int[] columnIndexes) throws SQLException {
            return GeneratedKeysQueryBuilder.create(sql, this.supportedQueryTypes).forColumnsByIndex(columnIndexes, this.fbDatabaseMetaData);
        }

        @Override
        public GeneratedKeysSupport.Query buildQuery(String sql, String[] columnNames) throws SQLException {
            return GeneratedKeysQueryBuilder.create(sql, this.supportedQueryTypes).forColumnsByName(columnNames);
        }

        @Override
        public Set<GeneratedKeysSupport.QueryType> supportedQueryTypes() {
            return Collections.unmodifiableSet(this.supportedQueryTypes);
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return true;
        }
    }
}

