/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.elasticsearch.core.internal.io.IOUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Streams {
    public static long copy(InputStream in, OutputStream out) throws IOException {
        long l;
        Exception err = null;
        try {
            long byteCount = in.transferTo(out);
            out.flush();
            l = byteCount;
        }
        catch (IOException | RuntimeException e) {
            try {
                err = e;
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.close(err, in, out);
                throw throwable;
            }
        }
        IOUtils.close(err, in, out);
        return l;
    }
}

