/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.SearchableSnapshotsRequestConverters;
import org.elasticsearch.client.searchable_snapshots.MountSnapshotRequest;

public class SearchableSnapshotsClient {
    private RestHighLevelClient restHighLevelClient;

    public SearchableSnapshotsClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = Objects.requireNonNull(restHighLevelClient);
    }

    public RestoreSnapshotResponse mountSnapshot(MountSnapshotRequest request, RequestOptions options) throws IOException {
        return (RestoreSnapshotResponse)this.restHighLevelClient.performRequestAndParseEntity(request, SearchableSnapshotsRequestConverters::mountSnapshot, options, RestoreSnapshotResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable mountSnapshotAsync(MountSnapshotRequest request, RequestOptions options, ActionListener<RestoreSnapshotResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SearchableSnapshotsRequestConverters::mountSnapshot, options, RestoreSnapshotResponse::fromXContent, listener, Collections.emptySet());
    }
}

