/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.util;

import java.util.Optional;
import java.util.Set;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.NumericRange;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.sdk.core.nodes.DataTypeNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaServerNode;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeWriter.class);

    public static void writeAttribute(AttributeContext context, UaServerNode node, AttributeId attributeId, DataValue value, @Nullable String indexRange) throws UaException {
        AttributeContext internalContext = new AttributeContext(context.getServer());
        NodeClass nodeClass = node.getNodeClass();
        if (attributeId == AttributeId.Value && nodeClass == NodeClass.Variable) {
            Set<AccessLevel> accessLevels = AttributeUtil.getAccessLevels(node, internalContext);
            if (!accessLevels.contains(AccessLevel.CurrentWrite)) {
                throw new UaException(2151350272L);
            }
            Set<AccessLevel> userAccessLevels = AttributeUtil.getUserAccessLevels(node, context);
            if (!userAccessLevels.contains(AccessLevel.CurrentWrite)) {
                throw new UaException(2149515264L);
            }
        } else {
            WriteMask writeMask = AttributeWriter.writeMaskForAttribute(attributeId);
            Set<WriteMask> writeMasks = AttributeUtil.getWriteMasks(node, internalContext);
            if (!writeMasks.contains(writeMask)) {
                throw new UaException(2151350272L);
            }
            Set<WriteMask> userWriteMasks = AttributeUtil.getUserWriteMasks(node, context);
            if (!userWriteMasks.contains(writeMask)) {
                throw new UaException(2149515264L);
            }
        }
        Variant updateVariant = value.getValue();
        if (indexRange != null) {
            NumericRange range = NumericRange.parse((String)indexRange);
            DataValue current = node.getAttribute(internalContext, attributeId);
            Variant currentVariant = current.getValue();
            Object valueAtRange = NumericRange.writeToValueAtRange((Variant)currentVariant, (Variant)updateVariant, (NumericRange)range);
            updateVariant = new Variant(valueAtRange);
        }
        DateTime sourceTime = value.getSourceTime();
        DateTime serverTime = value.getServerTime();
        value = new DataValue(updateVariant, value.getStatusCode(), sourceTime == null || sourceTime.isNull() ? DateTime.now() : sourceTime, serverTime == null || serverTime.isNull() ? DateTime.now() : serverTime);
        if (attributeId == AttributeId.Value) {
            Integer valueRank;
            NodeId dataType = (NodeId)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.DataType));
            if (dataType != null) {
                value = AttributeWriter.validateDataType(context.getServer(), dataType, value);
            }
            if ((valueRank = (Integer)AttributeUtil.extract(node.getAttribute(internalContext, AttributeId.ValueRank))) == null) {
                valueRank = 0;
            }
            if (valueRank > 0) {
                UInteger[] arrayDimensions = (UInteger[])AttributeUtil.extract(node.getAttribute(context, AttributeId.ArrayDimensions));
                AttributeWriter.validateArrayType(valueRank, arrayDimensions, value);
            }
        }
        node.setAttribute(context, attributeId, value);
    }

    private static WriteMask writeMaskForAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case AccessLevel: {
                return WriteMask.AccessLevel;
            }
            case ArrayDimensions: {
                return WriteMask.ArrayDimensions;
            }
            case BrowseName: {
                return WriteMask.BrowseName;
            }
            case ContainsNoLoops: {
                return WriteMask.ContainsNoLoops;
            }
            case DataType: {
                return WriteMask.DataType;
            }
            case Description: {
                return WriteMask.Description;
            }
            case DisplayName: {
                return WriteMask.DisplayName;
            }
            case EventNotifier: {
                return WriteMask.EventNotifier;
            }
            case Executable: {
                return WriteMask.Executable;
            }
            case Historizing: {
                return WriteMask.Historizing;
            }
            case InverseName: {
                return WriteMask.InverseName;
            }
            case IsAbstract: {
                return WriteMask.IsAbstract;
            }
            case MinimumSamplingInterval: {
                return WriteMask.MinimumSamplingInterval;
            }
            case NodeClass: {
                return WriteMask.NodeClass;
            }
            case NodeId: {
                return WriteMask.NodeId;
            }
            case Symmetric: {
                return WriteMask.Symmetric;
            }
            case UserAccessLevel: {
                return WriteMask.UserAccessLevel;
            }
            case UserExecutable: {
                return WriteMask.UserExecutable;
            }
            case UserWriteMask: {
                return WriteMask.UserWriteMask;
            }
            case Value: {
                return WriteMask.ValueForVariableType;
            }
            case ValueRank: {
                return WriteMask.ValueRank;
            }
            case WriteMask: {
                return WriteMask.WriteMask;
            }
        }
        throw new IllegalArgumentException("unknown AttributeId: " + attributeId);
    }

    private static DataValue validateDataType(OpcUaServer server, NodeId dataType, DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return value;
        }
        Object o = variant.getValue();
        if (o == null) {
            throw new UaException(2155085824L);
        }
        Class<?> valueClass = o.getClass().isArray() ? ArrayUtil.getType((Object)o) : o.getClass();
        Class<?> expectedClass = AttributeWriter.getExpectedClass(server, dataType, valueClass);
        if (expectedClass != null) {
            LOGGER.debug("dataTypeId={}, valueClass={}, expectedClass={}", new Object[]{dataType, valueClass.getSimpleName(), expectedClass.getSimpleName()});
            if (!expectedClass.isAssignableFrom(valueClass)) {
                if (o instanceof ByteString && expectedClass == UByte.class) {
                    ByteString byteString = (ByteString)o;
                    return new DataValue(new Variant((Object)byteString.uBytes()), value.getStatusCode(), value.getSourceTime(), value.getServerTime());
                }
                if (expectedClass == Variant.class) {
                    return value;
                }
                throw new UaException(2155085824L);
            }
        } else {
            throw new UaException(2155085824L);
        }
        return value;
    }

    private static void validateArrayType(Integer valueRank, UInteger[] arrayDimensions, DataValue value) throws UaException {
        Variant variant = value.getValue();
        if (variant == null) {
            return;
        }
        Object o = variant.getValue();
        if (o == null) {
            return;
        }
        boolean valueIsArray = o.getClass().isArray();
        switch (valueRank) {
            case -3: {
                int[] valueDimensions;
                if (!valueIsArray || (valueDimensions = ArrayUtil.getDimensions((Object)o)).length <= 1) break;
                throw new UaException(2155085824L);
            }
            case -2: {
                break;
            }
            case -1: {
                if (!valueIsArray) break;
                throw new UaException(2155085824L);
            }
            case 0: {
                if (valueIsArray) break;
                throw new UaException(2155085824L);
            }
            default: {
                if (!valueIsArray) {
                    throw new UaException(2155085824L);
                }
                int[] valueDimensions = ArrayUtil.getDimensions((Object)o);
                if (valueDimensions.length != valueRank) {
                    throw new UaException(2155085824L);
                }
                int[] nodeDimensions = Optional.ofNullable(arrayDimensions).map(uia -> {
                    int[] dims = new int[((UInteger[])uia).length];
                    for (int i = 0; i < ((UInteger[])uia).length; ++i) {
                        dims[i] = uia[i].intValue();
                    }
                    return dims;
                }).orElse(new int[0]);
                if (nodeDimensions.length <= 0) break;
                if (nodeDimensions.length != valueDimensions.length) {
                    throw new UaException(2155085824L);
                }
                for (int i = 0; i < nodeDimensions.length; ++i) {
                    if (nodeDimensions[i] <= 0 || valueDimensions[i] <= nodeDimensions[i]) continue;
                    throw new UaException(2155085824L);
                }
            }
        }
    }

    private static Class<?> getExpectedClass(OpcUaServer server, NodeId dataTypeId, Class<?> valueClass) throws UaException {
        if (TypeUtil.isBuiltin((NodeId)dataTypeId)) {
            return TypeUtil.getBackingClass((NodeId)dataTypeId);
        }
        if (AttributeWriter.subtypeOf(server, dataTypeId, Identifiers.Structure)) {
            return ExtensionObject.class;
        }
        if (AttributeWriter.subtypeOf(server, dataTypeId, Identifiers.Enumeration)) {
            return Integer.class;
        }
        NodeId superBuiltInType = AttributeWriter.findConcreteBuiltInSuperTypeId(server, dataTypeId);
        if (superBuiltInType != null) {
            return TypeUtil.getBackingClass((NodeId)superBuiltInType);
        }
        int valueDataTypeId = TypeUtil.getBuiltinTypeId(valueClass);
        if (valueDataTypeId > -1) {
            NodeId builtInTypeId = new NodeId(0, valueDataTypeId);
            if (dataTypeId.equals((Object)builtInTypeId) || AttributeWriter.subtypeOf(server, builtInTypeId, dataTypeId)) {
                return valueClass;
            }
            throw new UaException(2155085824L);
        }
        throw new UaException(2155085824L);
    }

    private static boolean subtypeOf(OpcUaServer server, NodeId dataTypeId, NodeId potentialSuperTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            NodeId superTypeId = AttributeWriter.getSuperTypeId(server, dataTypeId);
            if (superTypeId != null) {
                return superTypeId.equals((Object)potentialSuperTypeId) || AttributeWriter.subtypeOf(server, superTypeId, potentialSuperTypeId);
            }
            return false;
        }
        return false;
    }

    @Nullable
    private static NodeId findConcreteBuiltInSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        if (TypeUtil.isBuiltin((NodeId)dataTypeId) && AttributeWriter.isConcrete(server, dataTypeId)) {
            return dataTypeId;
        }
        NodeId superTypeId = AttributeWriter.getSuperTypeId(server, dataTypeId);
        if (superTypeId != null) {
            return AttributeWriter.findConcreteBuiltInSuperTypeId(server, superTypeId);
        }
        return null;
    }

    @Nullable
    private static NodeId getSuperTypeId(OpcUaServer server, NodeId dataTypeId) {
        UaNode dataTypeNode = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (dataTypeNode != null) {
            return dataTypeNode.getReferences().stream().filter(Reference.SUBTYPE_OF).flatMap(r -> StreamUtil.opt2stream((Optional)r.getTargetNodeId().toNodeId(server.getNamespaceTable()))).findFirst().orElse(null);
        }
        return null;
    }

    private static boolean isAbstract(OpcUaServer server, NodeId dataTypeId) {
        UaNode node = server.getAddressSpaceManager().getManagedNode(dataTypeId).orElse(null);
        if (node instanceof DataTypeNode) {
            return ((DataTypeNode)node).getIsAbstract();
        }
        return false;
    }

    private static boolean isConcrete(OpcUaServer server, NodeId dataTypeId) {
        return !AttributeWriter.isAbstract(server, dataTypeId);
    }
}

