/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.template.parser.Column;
import org.drools.template.parser.ColumnFactory;
import org.drools.template.parser.DecisionTableParseException;
import org.drools.template.parser.RuleTemplate;
import org.drools.template.parser.TemplateContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTemplateContainer
implements TemplateContainer {
    private String header;
    private Map<String, Column> columnMap = new HashMap<String, Column>();
    private List<Column> columns = new ArrayList<Column>();
    private Map<String, RuleTemplate> templates = new HashMap<String, RuleTemplate>();

    public DefaultTemplateContainer(String template) {
        this(DefaultTemplateContainer.class.getResourceAsStream(template));
    }

    public DefaultTemplateContainer(InputStream templateStream) {
        this.parseTemplate(templateStream);
        this.validateTemplate();
    }

    private void validateTemplate() {
        if (this.columns.size() == 0) {
            throw new DecisionTableParseException("Missing header columns");
        }
        if (this.templates.size() == 0) {
            throw new DecisionTableParseException("Missing templates");
        }
    }

    private void parseTemplate(InputStream templateStream) {
        try {
            ColumnFactory cf = new ColumnFactory();
            BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateStream));
            String line = null;
            StringBuffer header = new StringBuffer();
            boolean inTemplate = false;
            boolean inHeader = false;
            boolean inContents = false;
            RuleTemplate template = null;
            StringBuffer contents = new StringBuffer();
            while ((line = templateReader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.length() <= 0) continue;
                if (trimmed.startsWith("template header")) {
                    inHeader = true;
                    continue;
                }
                if (trimmed.startsWith("template")) {
                    inTemplate = true;
                    String quotedName = trimmed.substring(8).trim();
                    quotedName = quotedName.substring(1, quotedName.length() - 1);
                    template = new RuleTemplate(quotedName, this);
                    this.addTemplate(template);
                    continue;
                }
                if (trimmed.startsWith("package")) {
                    if (!inHeader) {
                        throw new DecisionTableParseException("Missing header");
                    }
                    inHeader = false;
                    header.append(line).append("\n");
                    continue;
                }
                if (inHeader) {
                    this.addColumn(cf.getColumn(trimmed));
                    continue;
                }
                if (!inTemplate && !inHeader) {
                    header.append(line).append("\n");
                    continue;
                }
                if (!inContents && trimmed.startsWith("rule")) {
                    inContents = true;
                    contents.append(line).append("\n");
                    continue;
                }
                if (trimmed.equals("end template")) {
                    template.setContents(contents.toString());
                    contents.setLength(0);
                    inTemplate = false;
                    inContents = false;
                    continue;
                }
                if (inContents) {
                    contents.append(line).append("\n");
                    continue;
                }
                if (!inTemplate) continue;
                template.addColumn(trimmed);
            }
            if (inTemplate) {
                throw new DecisionTableParseException("Missing end template");
            }
            this.header = header.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (templateStream != null) {
                this.closeStream(templateStream);
            }
        }
    }

    private void addTemplate(RuleTemplate template) {
        this.templates.put(template.getName(), template);
    }

    @Override
    public Map<String, RuleTemplate> getTemplates() {
        return this.templates;
    }

    private void addColumn(Column c) {
        this.columns.add(c);
        this.columnMap.put(c.getName(), c);
    }

    @Override
    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }

    @Override
    public Column getColumn(String name) {
        return this.columnMap.get(name);
    }
}

