/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.ui.convert.NodeConvertAbstract;
import org.dromara.warm.flow.ui.convert.NodeConvertUtil;

public class ParallelNodeConvert
extends NodeConvertAbstract {
    @Override
    public List<Node> convert(Map<String, Object> jsonObject, String startNodeId, String endNodeId, String nextNodeId) {
        ArrayList<Node> seaflowNodeList = new ArrayList<Node>();
        String startParallelNodeId = (String)jsonObject.get("nodeId");
        Node serialNode = FlowEngine.newNode();
        serialNode.setNodeCode(startParallelNodeId);
        serialNode.setNodeType(NodeType.PARALLEL.getKey());
        seaflowNodeList.add(serialNode);
        Node endNode = FlowEngine.newNode();
        endNode.setNodeCode(UUID.randomUUID().toString());
        List childNodes = (List)jsonObject.get("childNodes");
        ArrayList<Skip> startSkips = new ArrayList<Skip>();
        for (int j = 0; j < childNodes.size(); ++j) {
            List jsonArray = (List)childNodes.get(j);
            ((Map)jsonArray.get(0)).put("nodeType", NodeType.BETWEEN.getValue());
            Skip startNodeSkip = FlowEngine.newSkip();
            startNodeSkip.setSkipType(SkipType.PASS.getKey());
            startNodeSkip.setNextNodeCode((String)((Map)jsonArray.get(0)).get("nodeId"));
            startSkips.add(startNodeSkip);
            List<Node> convert = NodeConvertUtil.convert(jsonArray, startNodeId, endNodeId);
            Node seaflowNode = convert.get(convert.size() - 1);
            Skip flowSkip = FlowEngine.newSkip();
            flowSkip.setSkipType(SkipType.PASS.getKey());
            flowSkip.setNextNodeCode(endNode.getNodeCode());
            seaflowNode.getSkipList().add(flowSkip);
            seaflowNodeList.addAll(convert);
        }
        serialNode.setSkipList(startSkips);
        String emptyNodeCode = UUID.randomUUID().toString();
        Skip parallelOutSkip = FlowEngine.newSkip();
        parallelOutSkip.setSkipType(SkipType.PASS.getKey());
        parallelOutSkip.setNextNodeCode(emptyNodeCode);
        endNode.setSkipList(Arrays.asList(parallelOutSkip));
        Node emptyNode = FlowEngine.newNode();
        emptyNode.setNodeCode(emptyNodeCode);
        emptyNode.setNodeType(NodeType.BETWEEN.getKey());
        String emptyApprove = "{\"type\":\"EMPTY\",\"value\":[]}";
        if (nextNodeId != null) {
            ArrayList<Skip> endSkipList = new ArrayList<Skip>();
            for (String nodeId : nextNodeId.split(",")) {
                Skip endSkip = FlowEngine.newSkip();
                endSkip.setSkipType(SkipType.PASS.getKey());
                endSkip.setNextNodeCode(nodeId);
                endSkipList.add(endSkip);
            }
            emptyNode.setSkipList(endSkipList);
        }
        seaflowNodeList.add(endNode);
        seaflowNodeList.add(emptyNode);
        return seaflowNodeList;
    }

    @Override
    public String getType() {
        return "parallel";
    }
}

