/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.controller;

import java.util.Collections;
import java.util.List;
import org.dromara.warm.flow.core.FlowFactory;
import org.dromara.warm.flow.core.dto.ApiResult;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.utils.ExceptionUtil;
import org.dromara.warm.flow.ui.dto.DefDto;
import org.dromara.warm.flow.ui.dto.HandlerQuery;
import org.dromara.warm.flow.ui.service.HandlerSelectService;
import org.dromara.warm.flow.ui.vo.HandlerSelectVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/warm-flow"})
public class WarmFlowController {
    private static final Logger log = LoggerFactory.getLogger(WarmFlowController.class);

    @PostMapping(value={"/save-xml"})
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> saveXml(@RequestBody DefDto defDto) throws Exception {
        FlowFactory.defService().saveXml(defDto.getId(), defDto.getXmlString());
        return ApiResult.ok();
    }

    @GetMapping(value={"/xml-string/{id}"})
    public ApiResult<String> xmlString(@PathVariable(value="id") Long id) {
        try {
            return ApiResult.ok((Object)FlowFactory.defService().xmlString(id));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d41\u7a0bxml\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6d41\u7a0bxml\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    @PostMapping(value={"/save-json"})
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> saveJson(@RequestBody DefDto defDto) throws Exception {
        FlowFactory.defService().saveJson(defDto.getId(), defDto.getJsonString());
        return ApiResult.ok();
    }

    @GetMapping(value={"/json-string/{id}"})
    public ApiResult<String> jsonString(@PathVariable(value="id") Long id) {
        try {
            return ApiResult.ok((Object)FlowFactory.defService().jsonString(id));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/handler-type"})
    public ApiResult<List<String>> handlerType() {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok(Collections.emptyList());
            }
            List handlerType = handlerSelectService.getHandlerType();
            return ApiResult.ok((Object)handlerType);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/handler-result"})
    public ApiResult<HandlerSelectVo> handlerResult(HandlerQuery query) {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok((Object)new HandlerSelectVo());
            }
            HandlerSelectVo handlerSelectVo = handlerSelectService.getHandlerSelect(query);
            return ApiResult.ok((Object)handlerSelectVo);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25", (Exception)e));
        }
    }

    @GetMapping(value={"/previous-node-list/{definitionId}/{nowNodeCode}"})
    public ApiResult<List<Node>> previousNodeList(@PathVariable(value="definitionId") Long definitionId, @PathVariable(value="nowNodeCode") String nowNodeCode) {
        try {
            return ApiResult.ok((Object)FlowFactory.nodeService().previousNodeList(definitionId, nowNodeCode));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6240\u6709\u7684\u524d\u7f6e\u8282\u70b9\u96c6\u5408\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6240\u6709\u7684\u524d\u7f6e\u8282\u70b9\u96c6\u5408\u5931\u8d25", (Exception)e));
        }
    }
}

