/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.config;

import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.dromara.sms4j.api.smsProxy.RestrictedProcess;
import org.dromara.sms4j.api.smsProxy.SmsInvocationHandler;
import org.dromara.sms4j.api.universal.RedisUtil;
import org.dromara.sms4j.comm.config.SmsBanner;
import org.dromara.sms4j.comm.config.SmsConfig;
import org.dromara.sms4j.comm.config.SmsSqlConfig;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.factory.BeanFactory;
import org.dromara.sms4j.core.SupplierSqlConfig;
import org.dromara.sms4j.starter.aop.RestrictedProcessImpl;
import org.dromara.sms4j.starter.config.SupplierConfig;
import org.dromara.sms4j.starter.utils.ConfigUtil;
import org.dromara.sms4j.starter.utils.RedisUtils;
import org.dromara.sms4j.starter.utils.SpringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

public class SmsAutowiredConfig {
    private static final Logger log = LoggerFactory.getLogger(SmsAutowiredConfig.class);
    private final SpringUtil springUtil;

    public SmsAutowiredConfig(SpringUtil springUtil) {
        this.springUtil = springUtil;
    }

    @Bean
    @ConfigurationProperties(prefix="sms.sql")
    protected SmsSqlConfig smsSqlConfig() {
        return BeanFactory.getSmsSqlConfig();
    }

    @Bean
    @Primary
    @ConfigurationProperties(prefix="sms")
    protected SmsConfig smsConfig() {
        return BeanFactory.getSmsConfig();
    }

    @Bean
    protected DelayedTime delayedTime() {
        return BeanFactory.getDelayedTime();
    }

    @Bean(value={"smsExecutor"})
    protected Executor taskExecutor(SmsConfig config) {
        return BeanFactory.setExecutor((SmsConfig)config);
    }

    @Bean
    protected ConfigUtil configUtil(Environment environment) {
        return new ConfigUtil(environment);
    }

    @Bean
    @ConditionalOnProperty(prefix="sms", name={"config-type"}, havingValue="config_file")
    protected SupplierConfig supplierConfig(SmsConfig smsConfig) {
        return new SupplierConfig();
    }

    @Bean
    @ConditionalOnProperty(prefix="sms", name={"config-type"}, havingValue="sql_config")
    protected SupplierSqlConfig supplierSqlConfig(SmsSqlConfig smsSqlConfig) throws SQLException {
        DataSource bean = SpringUtil.getBean(DataSource.class);
        if (!Objects.isNull(bean)) {
            BeanFactory.getJDBCTool().setConnection(bean.getConnection());
        }
        return new SupplierSqlConfig();
    }

    void init() {
        if (BeanFactory.getSmsConfig().getRedisCache().booleanValue()) {
            if (!SpringUtil.interfaceExist(RedisUtil.class)) {
                this.springUtil.createBean(RedisUtils.class);
            }
            SmsInvocationHandler.setRestrictedProcess((RestrictedProcess)new RestrictedProcessImpl());
            log.debug("The redis cache is enabled for sms4j");
        }
        if (BeanFactory.getSmsConfig().getIsPrint().booleanValue()) {
            SmsBanner.PrintBanner((String)"V 2.1.0");
        }
    }
}

