/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.provider.factory;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.provider.config.SmsConfig;

public class BeanFactory {
    private static DelayedTime delayedTime;
    private static Executor executor;
    private static SmsConfig smsConfig;

    private BeanFactory() {
    }

    public static DelayedTime getDelayedTime() {
        if (delayedTime == null) {
            delayedTime = new DelayedTime();
        }
        return delayedTime;
    }

    public static Executor setExecutor(SmsConfig config) {
        if (executor == null) {
            ThreadPoolExecutor ex = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaxPoolSize(), config.getQueueCapacity().intValue(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(config.getMaxPoolSize()));
            ex.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            executor = ex;
        }
        return executor;
    }

    public static Executor setExecutor(Executor exec) {
        executor = exec;
        return executor;
    }

    public static Executor getExecutor() {
        if (executor == null) {
            ThreadPoolExecutor ex = new ThreadPoolExecutor(smsConfig.getCorePoolSize(), smsConfig.getMaxPoolSize(), smsConfig.getQueueCapacity().intValue(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(smsConfig.getMaxPoolSize()));
            ex.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            executor = ex;
        }
        return executor;
    }

    public static SmsConfig getSmsConfig() {
        if (smsConfig == null) {
            smsConfig = new SmsConfig();
        }
        return smsConfig;
    }
}

