/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.unisms.service;

import cn.hutool.core.map.MapUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.dromara.sms4j.unisms.config.UniConfig;
import org.dromara.sms4j.unisms.core.Uni;
import org.dromara.sms4j.unisms.core.UniResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniSmsImpl
extends AbstractSmsBlend<UniConfig> {
    private static final Logger log = LoggerFactory.getLogger(UniSmsImpl.class);

    public UniSmsImpl(UniConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public UniSmsImpl(UniConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "unisms";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        if ("".equals(((UniConfig)this.getConfig()).getTemplateId()) && "".equals(((UniConfig)this.getConfig()).getTemplateName())) {
            throw new SmsBlendException("\u914d\u7f6e\u6587\u4ef6\u6a21\u677fid\u548c\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((UniConfig)this.getConfig()).getTemplateName(), message);
        return this.sendMessage(phone, ((UniConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        return this.sendMessage(phone, ((UniConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        HashMap data = MapUtil.newHashMap((int)4, (boolean)true);
        data.put("to", Collections.singletonList(phone));
        data.put("signature", ((UniConfig)this.getConfig()).getSignature());
        data.put("templateId", templateId);
        data.put("templateData", messages);
        return this.getSmsResponse(data);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        if ("".equals(((UniConfig)this.getConfig()).getTemplateId()) && "".equals(((UniConfig)this.getConfig()).getTemplateName())) {
            throw new SmsBlendException("\u914d\u7f6e\u6587\u4ef6\u6a21\u677fid\u548c\u6a21\u677f\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
        map.put(((UniConfig)this.getConfig()).getTemplateName(), message);
        return this.massTexting(phones, ((UniConfig)this.getConfig()).getTemplateId(), map);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        if (phones.size() > 1000) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e1000");
        }
        HashMap data = MapUtil.newHashMap((int)4, (boolean)true);
        data.put("to", phones);
        data.put("signature", ((UniConfig)this.getConfig()).getSignature());
        data.put("templateId", templateId);
        data.put("templateData", messages);
        return this.getSmsResponse(data);
    }

    private SmsResponse getSmsResponse(Map<String, Object> data) {
        SmsResponse smsResponse = new SmsResponse();
        try {
            UniResponse send = Uni.getClient(((UniConfig)this.getConfig()).getRetryInterval(), ((UniConfig)this.getConfig()).getMaxRetries()).request("sms.message.send", data);
            smsResponse.setSuccess("0".equals(send.code));
            smsResponse.setData((Object)send);
            smsResponse.setConfigId(this.getConfigId());
        }
        catch (Exception e) {
            smsResponse.setSuccess(false);
        }
        return smsResponse;
    }
}

