/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.provider.service;

import cn.hutool.core.util.StrUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.callback.CallBack;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.utils.SmsHttpUtils;
import org.dromara.sms4j.provider.factory.BeanFactory;

public abstract class AbstractSmsBlend<C extends SupplierConfig>
implements SmsBlend {
    private final String configId;
    private final C config;
    protected final Executor pool;
    protected final DelayedTime delayed;
    protected final SmsHttpUtils http = SmsHttpUtils.instance();

    protected AbstractSmsBlend(C config, Executor pool, DelayedTime delayed) {
        this.configId = StrUtil.isEmpty((CharSequence)config.getConfigId()) ? this.getSupplier() : config.getConfigId();
        this.config = config;
        this.pool = pool;
        this.delayed = delayed;
    }

    protected AbstractSmsBlend(C config) {
        this.configId = StrUtil.isEmpty((CharSequence)config.getConfigId()) ? this.getSupplier() : config.getConfigId();
        this.config = config;
        this.pool = BeanFactory.getExecutor();
        this.delayed = BeanFactory.getDelayedTime();
    }

    protected C getConfig() {
        return this.config;
    }

    public abstract SmsResponse sendMessage(String var1, String var2);

    public abstract SmsResponse sendMessage(String var1, LinkedHashMap<String, String> var2);

    public abstract SmsResponse sendMessage(String var1, String var2, LinkedHashMap<String, String> var3);

    public abstract SmsResponse massTexting(List<String> var1, String var2);

    public abstract SmsResponse massTexting(List<String> var1, String var2, LinkedHashMap<String, String> var3);

    public final void sendMessageAsync(String phone, String message, CallBack callBack) {
        CompletableFuture<SmsResponse> smsResponseCompletableFuture = CompletableFuture.supplyAsync(() -> this.sendMessage(phone, message), this.pool);
        smsResponseCompletableFuture.thenAcceptAsync(arg_0 -> ((CallBack)callBack).callBack(arg_0));
    }

    public final void sendMessageAsync(String phone, String message) {
        this.pool.execute(() -> this.sendMessage(phone, message));
    }

    public final void sendMessageAsync(String phone, String templateId, LinkedHashMap<String, String> messages, CallBack callBack) {
        CompletableFuture<SmsResponse> smsResponseCompletableFuture = CompletableFuture.supplyAsync(() -> this.sendMessage(phone, templateId, messages), this.pool);
        smsResponseCompletableFuture.thenAcceptAsync(arg_0 -> ((CallBack)callBack).callBack(arg_0));
    }

    public final void sendMessageAsync(String phone, String templateId, LinkedHashMap<String, String> messages) {
        this.pool.execute(() -> this.sendMessage(phone, templateId, messages));
    }

    public final void delayedMessage(final String phone, final String message, Long delayedTime) {
        this.delayed.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractSmsBlend.this.sendMessage(phone, message);
            }
        }, delayedTime.longValue());
    }

    public final void delayedMessage(final String phone, final String templateId, final LinkedHashMap<String, String> messages, Long delayedTime) {
        this.delayed.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractSmsBlend.this.sendMessage(phone, templateId, messages);
            }
        }, delayedTime.longValue());
    }

    public final void delayMassTexting(final List<String> phones, final String message, Long delayedTime) {
        this.delayed.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractSmsBlend.this.massTexting(phones, message);
            }
        }, delayedTime.longValue());
    }

    public final void delayMassTexting(final List<String> phones, final String templateId, final LinkedHashMap<String, String> messages, Long delayedTime) {
        this.delayed.schedule(new TimerTask(){

            @Override
            public void run() {
                AbstractSmsBlend.this.massTexting(phones, templateId, messages);
            }
        }, delayedTime.longValue());
    }

    public String getConfigId() {
        return this.configId;
    }
}

