/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.emay.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.emay.config.EmayConfig;
import org.dromara.sms4j.emay.util.EmayBuilder;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmaySmsImpl
extends AbstractSmsBlend<EmayConfig> {
    private static final Logger log = LoggerFactory.getLogger(EmaySmsImpl.class);
    private int retry = 0;

    public EmaySmsImpl(EmayConfig config, Executor pool, DelayedTime delayed) {
        super(config, pool, delayed);
    }

    public EmaySmsImpl(EmayConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "emay";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        SmsResponse smsResponse;
        String url = ((EmayConfig)this.getConfig()).getRequestUrl();
        Map<String, Object> params = EmayBuilder.buildRequestBody(((EmayConfig)this.getConfig()).getAccessKeyId(), ((EmayConfig)this.getConfig()).getAccessKeySecret(), phone, message);
        HashMap headers = MapUtil.newHashMap((int)1, (boolean)true);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        try {
            smsResponse = this.getResponse(this.http.postUrl(url, (Map)headers, params));
        }
        catch (SmsBlendException e) {
            smsResponse = new SmsResponse();
            smsResponse.setSuccess(false);
            smsResponse.setData((Object)e.getMessage());
        }
        if (smsResponse.isSuccess() || this.retry == ((EmayConfig)this.getConfig()).getMaxRetries()) {
            this.retry = 0;
            return smsResponse;
        }
        return this.requestRetry(phone, message);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        return this.sendMessage(phone, ((EmayConfig)this.getConfig()).getTemplateId(), messages);
    }

    private SmsResponse requestRetry(String phone, String message) {
        this.http.safeSleep(((EmayConfig)this.getConfig()).getRetryInterval());
        ++this.retry;
        log.warn("\u77ed\u4fe1\u7b2c {} \u6b21\u91cd\u65b0\u53d1\u9001", (Object)this.retry);
        return this.sendMessage(phone, message);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        return this.sendMessage(phone, EmayBuilder.listToString(list));
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        if (phones.size() > 500) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e500");
        }
        return this.sendMessage(SmsUtils.listToString(phones), message);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        if (phones.size() > 500) {
            throw new SmsBlendException("\u5355\u6b21\u53d1\u9001\u8d85\u8fc7\u6700\u5927\u53d1\u9001\u4e0a\u9650\uff0c\u5efa\u8bae\u6bcf\u6b21\u7fa4\u53d1\u77ed\u4fe1\u4eba\u6570\u4f4e\u4e8e500");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : messages.entrySet()) {
            list.add(entry.getValue());
        }
        return this.sendMessage(SmsUtils.listToString(phones), EmayBuilder.listToString(list));
    }

    private SmsResponse getResponse(JSONObject resJson) {
        SmsResponse smsResponse = new SmsResponse();
        smsResponse.setSuccess("success".equalsIgnoreCase(resJson.getStr((Object)"code")));
        smsResponse.setData((Object)resJson);
        smsResponse.setConfigId(this.getConfigId());
        return smsResponse;
    }
}

