/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.dingzhong.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.comm.delayedTime.DelayedTime;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.dingzhong.config.DingZhongConfig;
import org.dromara.sms4j.dingzhong.util.DingZhongHelper;
import org.dromara.sms4j.provider.service.AbstractSmsBlend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingZhongSmsImpl
extends AbstractSmsBlend<DingZhongConfig> {
    private static final Logger log = LoggerFactory.getLogger(DingZhongSmsImpl.class);

    public DingZhongSmsImpl(DingZhongConfig config, Executor pool, DelayedTime delayedTime) {
        super(config, pool, delayedTime);
    }

    public DingZhongSmsImpl(DingZhongConfig config) {
        super(config);
    }

    public String getSupplier() {
        return "dingzhong";
    }

    @Override
    public SmsResponse sendMessage(String phone, String message) {
        DingZhongHelper helper = new DingZhongHelper((DingZhongConfig)this.getConfig(), this.http);
        HashMap paramMap = MapUtil.newHashMap((int)4, (boolean)true);
        paramMap.put("cdkey", ((DingZhongConfig)this.getConfig()).getAccessKeyId());
        paramMap.put("password", ((DingZhongConfig)this.getConfig()).getAccessKeySecret());
        paramMap.put("mobile", phone);
        paramMap.put("msg", message);
        return helper.smsResponse(paramMap);
    }

    @Override
    public SmsResponse sendMessage(String phone, LinkedHashMap<String, String> messages) {
        return this.sendMessage(phone, ((DingZhongConfig)this.getConfig()).getTemplateId(), messages);
    }

    @Override
    public SmsResponse sendMessage(String phone, String templateId, LinkedHashMap<String, String> messages) {
        if (Objects.isNull(messages)) {
            messages = new LinkedHashMap();
        }
        DingZhongHelper helper = new DingZhongHelper((DingZhongConfig)this.getConfig(), this.http);
        HashMap paramMap = MapUtil.newHashMap((int)5, (boolean)true);
        paramMap.put("cdkey", ((DingZhongConfig)this.getConfig()).getAccessKeyId());
        paramMap.put("password", ((DingZhongConfig)this.getConfig()).getAccessKeySecret());
        paramMap.put("mobile", phone);
        paramMap.put("templateId", templateId);
        JSONObject params = new JSONObject();
        params.putAll(messages);
        paramMap.put("msgParam", params.toString());
        return helper.smsResponse(paramMap);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String message) {
        return this.sendMessage(SmsUtils.arrayToString(phones), message);
    }

    @Override
    public SmsResponse massTexting(List<String> phones, String templateId, LinkedHashMap<String, String> messages) {
        return this.sendMessage(SmsUtils.arrayToString(phones), templateId, messages);
    }
}

