/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.common.utils.StringUtils;
import org.dromara.easyes.spring.MapperScannerConfigurer;
import org.dromara.easyes.spring.annotation.EsMapperScan;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class MapperScannerRegister
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EsMapperScan.class.getName()));
        List<Object> basePackages = new ArrayList();
        if (mapperScanAttrs != null) {
            basePackages = Arrays.stream(mapperScanAttrs.getStringArray("value")).filter(org.springframework.util.StringUtils::hasText).map(map -> {
                if (map.contains("${") && map.contains("}")) {
                    String basePackage = this.environment.resolvePlaceholders(map);
                    LogUtils.formatInfo((String)"Scan Easy-Es Mapper[%s -> %s]", (Object[])new Object[]{map, basePackage});
                    return basePackage;
                }
                return map;
            }).collect(Collectors.toList());
        } else {
            String propertyValue = (String)this.environment.getProperty("easy-es.mappers", String.class, (Object)"");
            if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
                basePackages = Arrays.asList(propertyValue.split(","));
            }
        }
        if (!basePackages.isEmpty()) {
            this.registerBeanDefinitions(registry, MapperScannerRegister.generateBaseBeanName(importingClassMetadata), org.springframework.util.StringUtils.toStringArray(basePackages));
        }
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry, String beanName, String ... basePackages) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
        builder.addPropertyValue("basePackage", (Object)String.join((CharSequence)",", basePackages));
        builder.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    private static String generateBaseBeanName(AnnotationMetadata importingClassMetadata) {
        return importingClassMetadata.getClassName() + "#" + MapperScannerRegister.class.getSimpleName() + "#" + 0;
    }
}

