/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.Save;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.pptx4j.pml.Presentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveSlides
extends Save {
    protected static Logger log = LoggerFactory.getLogger(PresentationMLPackage.class);
    private Presentation.SldIdLst existingldIdLst;
    private Presentation.SldIdLst partialSldIdLst;
    private Set<String> slideRels = new HashSet<String>();

    private SaveSlides(OpcPackage p) {
        super(p);
    }

    public SaveSlides(PresentationMLPackage pmlPkg, int[] slideNumber) {
        super(pmlPkg);
        MainPresentationPart presentation = pmlPkg.getMainPresentationPart();
        RelationshipsPart rels = presentation.getRelationshipsPart();
        this.existingldIdLst = ((Presentation)presentation.getJaxbElement()).getSldIdLst();
        this.partialSldIdLst = new Presentation.SldIdLst();
        for (int i : slideNumber) {
            Presentation.SldIdLst.SldId sldId = null;
            try {
                sldId = (Presentation.SldIdLst.SldId)this.existingldIdLst.getSldId().get(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.error("Presentation has fewer slides than (0-based) " + i);
                throw new RuntimeException("Presentation has fewer slides than (0-based) " + i);
            }
            Presentation.SldIdLst.SldId sldIdClone = new Presentation.SldIdLst.SldId();
            sldIdClone.setId(sldId.getId());
            sldIdClone.setRid(sldId.getRid());
            this.partialSldIdLst.getSldId().add(sldIdClone);
            this.slideRels.add(sldId.getRid());
        }
    }

    @Override
    public void savePart(Part part) throws Docx4JException, IOException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        if (this.handled.get(resolvedPartUri) != null) {
            log.debug(".. duplicate save avoided ..");
            return;
        }
        if (part instanceof BinaryPart) {
            log.debug(".. saving binary stuff");
            this.p.getTargetPartStore().saveBinaryPart(part);
        } else if (part instanceof MainPresentationPart) {
            log.info(".. special treatment saving MPP ");
            MainPresentationPart presentation = (MainPresentationPart)part;
            ((Presentation)presentation.getJaxbElement()).setSldIdLst(this.partialSldIdLst);
            this.saveRawXmlPart(part);
            ((Presentation)presentation.getJaxbElement()).setSldIdLst(this.existingldIdLst);
        } else {
            this.saveRawXmlPart(part);
        }
        this.handled.put(resolvedPartUri, resolvedPartUri);
        RelationshipsPart rrp = part.getRelationshipsPart(false);
        if (rrp != null) {
            if (part instanceof MainPresentationPart) {
                log.info(".. special treatment saving MPP rels");
                Relationships existingRels = rrp.getRelationships();
                Relationships partialRels = new Relationships();
                for (Relationship r : existingRels.getRelationship()) {
                    Relationship clonedRel;
                    if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide".equals(r.getType())) {
                        if (!this.slideRels.contains(r.getId())) continue;
                        clonedRel = XmlUtils.deepCopy(r, Context.jcRelationships);
                        partialRels.getRelationship().add(clonedRel);
                        continue;
                    }
                    clonedRel = XmlUtils.deepCopy(r, Context.jcRelationships);
                    partialRels.getRelationship().add(clonedRel);
                }
                rrp.setJaxbElement(partialRels);
                this.saveRawXmlPart(rrp);
                this.addPartsFromRelationships(rrp);
                rrp.setJaxbElement(existingRels);
            } else if (rrp.getRelationships().getRelationship().size() > 0) {
                this.saveRawXmlPart(rrp);
                this.addPartsFromRelationships(rrp);
            }
        }
    }
}

