/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts;

import java.io.File;
import java.net.URI;
import org.docx4j.fonts.fop.apps.FOPException;
import org.docx4j.fonts.fop.fonts.FontCache;
import org.docx4j.fonts.fop.fonts.FontCacheManager;

public final class FontCacheManagerFactory {
    private FontCacheManagerFactory() {
    }

    public static FontCacheManager createDefault() {
        return new FontCacheManagerImpl();
    }

    public static FontCacheManager createDisabled() {
        return new DisabledFontCacheManager();
    }

    private static final class DisabledFontCacheManager
    implements FontCacheManager {
        private DisabledFontCacheManager() {
        }

        @Override
        public FontCache load() {
            return null;
        }

        @Override
        public void save() throws FOPException {
        }

        @Override
        public void delete() throws FOPException {
            throw new FOPException("Font Cache disabled");
        }

        @Override
        public void setCacheFile(URI fontCacheURI) {
        }
    }

    private static final class FontCacheManagerImpl
    implements FontCacheManager {
        private File cacheFile;
        private FontCache fontCache;

        private FontCacheManagerImpl() {
        }

        @Override
        public FontCache load() {
            if (this.fontCache == null) {
                this.fontCache = FontCache.loadFrom(this.getCacheFile(false));
                if (this.fontCache == null) {
                    this.fontCache = new FontCache();
                }
            }
            return this.fontCache;
        }

        @Override
        public void save() throws FOPException {
            if (this.fontCache != null && this.fontCache.hasChanged()) {
                this.fontCache.saveTo(this.getCacheFile(true));
            }
        }

        @Override
        public void delete() throws FOPException {
            if (!this.getCacheFile(true).delete()) {
                throw new FOPException("Failed to flush the font cache file '" + this.cacheFile + "'.");
            }
        }

        private File getCacheFile(boolean forWriting) {
            if (this.cacheFile != null) {
                return this.cacheFile;
            }
            return FontCache.getDefaultCacheFile(forWriting);
        }

        @Override
        public void setCacheFile(URI fontCacheURI) {
            this.cacheFile = new File(fontCacheURI);
        }
    }
}

