/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.xml.security.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoreAllErrorHandler
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(IgnoreAllErrorHandler.class);
    private static final boolean warnOnExceptions = IgnoreAllErrorHandler.getProperty("org.docx4j.org.apache.xml.security.test.warn.on.exceptions");
    private static final boolean throwExceptions = IgnoreAllErrorHandler.getProperty("org.docx4j.org.apache.xml.security.test.throw.exceptions");

    private static boolean getProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(name);
            }
        });
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.warn("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.error("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.warn("", (Throwable)ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }
}

