/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.parallel;

import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBoolean {
    private static final Logger log = LoggerFactory.getLogger(MultiBoolean.class);
    private final int numEntries;
    private int holder = 0;
    private int max = 0;
    private boolean oneTime;
    private MultiBoolean timeTracker;

    public MultiBoolean(int numEntries) {
        this(numEntries, false);
    }

    public MultiBoolean(int numEntries, boolean initialValue) {
        this(numEntries, initialValue, false);
    }

    public MultiBoolean(int numEntries, boolean initialValue, boolean oneTime) {
        if (numEntries > 32) {
            throw new UnsupportedOperationException("Up to 32 entries can be tracked at once.");
        }
        this.oneTime = oneTime;
        this.numEntries = numEntries;
        for (int i = 1; i <= numEntries; ++i) {
            this.max |= 1 << i;
        }
        if (initialValue) {
            this.holder = this.max;
        }
        if (oneTime) {
            this.timeTracker = new MultiBoolean(numEntries, false, false);
        }
    }

    public void set(boolean value, int entry) {
        if (entry > this.numEntries || entry < 0) {
            throw new ND4JIllegalStateException("Entry index given (" + entry + ")in is higher then configured one (" + this.numEntries + ")");
        }
        if (this.oneTime && this.timeTracker.get(entry)) {
            return;
        }
        this.holder = value ? (this.holder |= 1 << entry + 1) : (this.holder &= ~(1 << entry + 1));
        if (this.oneTime) {
            this.timeTracker.set(true, entry);
        }
    }

    public boolean get(int entry) {
        if (entry > this.numEntries || entry < 0) {
            throw new ND4JIllegalStateException("Entry index given (" + entry + ")in is higher then configured one (" + this.numEntries + ")");
        }
        return (this.holder & 1 << entry + 1) != 0;
    }

    public boolean allTrue() {
        return this.holder == this.max;
    }

    public boolean allFalse() {
        return this.holder == 0;
    }
}

