/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkDataSetIterator
implements DataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(BenchmarkDataSetIterator.class);
    private INDArray baseFeatures;
    private INDArray baseLabels;
    private long limit;
    private AtomicLong counter = new AtomicLong(0L);

    public BenchmarkDataSetIterator(int[] featuresShape, int numLabels, int totalIterations) {
        this(featuresShape, numLabels, totalIterations, -1, -1);
    }

    public BenchmarkDataSetIterator(int[] featuresShape, int numLabels, int totalIterations, int gridWidth, int gridHeight) {
        this.baseFeatures = Nd4j.rand((int[])featuresShape);
        this.baseLabels = gridWidth > 0 && gridHeight > 0 ? Nd4j.create((int[])new int[]{featuresShape[0], numLabels, gridWidth, gridHeight}) : Nd4j.create((int)featuresShape[0], (int)numLabels);
        this.baseLabels.getColumn(1L).assign((Number)1.0);
        Nd4j.getExecutioner().commit();
        this.limit = totalIterations;
    }

    public BenchmarkDataSetIterator(DataSet example, int totalIterations) {
        this.baseFeatures = example.getFeatures().dup();
        this.baseLabels = example.getLabels().dup();
        Nd4j.getExecutioner().commit();
        this.limit = totalIterations;
    }

    public DataSet next(int i) {
        throw new UnsupportedOperationException();
    }

    public int inputColumns() {
        return 0;
    }

    public int totalOutcomes() {
        return 0;
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        this.counter.set(0L);
    }

    public int batch() {
        return 0;
    }

    public void setPreProcessor(DataSetPreProcessor dataSetPreProcessor) {
    }

    public DataSetPreProcessor getPreProcessor() {
        return null;
    }

    public List<String> getLabels() {
        return null;
    }

    public boolean hasNext() {
        return this.counter.get() < this.limit;
    }

    public DataSet next() {
        this.counter.incrementAndGet();
        DataSet ds = new DataSet(this.baseFeatures, this.baseLabels);
        return ds;
    }

    public void remove() {
    }
}

