/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MultipleEpochsIterator
implements DataSetIterator {
    @VisibleForTesting
    protected int epochs = 0;
    protected int numEpochs;
    protected int batch;
    protected int lastBatch = this.batch = 0;
    protected DataSetIterator iter;
    protected org.nd4j.linalg.dataset.DataSet ds;
    protected List<org.nd4j.linalg.dataset.DataSet> batchedDS = Lists.newArrayList();
    protected static final Logger log = LoggerFactory.getLogger(MultipleEpochsIterator.class);
    protected DataSetPreProcessor preProcessor;
    protected boolean newEpoch = false;
    protected AtomicLong iterationsCounter = new AtomicLong(0L);
    protected long totalIterations = Long.MAX_VALUE;

    @Deprecated
    public MultipleEpochsIterator(int numEpochs, DataSetIterator iter) {
        this.numEpochs = numEpochs;
        this.iter = iter;
    }

    @Deprecated
    public MultipleEpochsIterator(int numEpochs, DataSetIterator iter, int queueSize) {
        this.numEpochs = numEpochs;
        this.iter = iter;
    }

    @Deprecated
    public MultipleEpochsIterator(DataSetIterator iter, int queueSize, long totalIterations) {
        this.numEpochs = Integer.MAX_VALUE;
        this.iter = iter;
        this.totalIterations = totalIterations;
    }

    @Deprecated
    public MultipleEpochsIterator(DataSetIterator iter, long totalIterations) {
        this.numEpochs = Integer.MAX_VALUE;
        this.iter = iter;
        this.totalIterations = totalIterations;
    }

    @Deprecated
    public MultipleEpochsIterator(int numEpochs, org.nd4j.linalg.dataset.DataSet ds) {
        this.numEpochs = numEpochs;
        this.ds = ds;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        org.nd4j.linalg.dataset.DataSet next;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        ++this.batch;
        this.iterationsCounter.incrementAndGet();
        if (this.iter == null) {
            if (num == -1) {
                next = this.ds;
                if (this.epochs < this.numEpochs) {
                    this.trackEpochs();
                }
            } else {
                if (this.batchedDS.isEmpty() && num > 0) {
                    this.batchedDS = this.ds.batchBy(num);
                }
                next = this.batchedDS.get(this.batch);
                if (this.batch + 1 == this.batchedDS.size()) {
                    this.trackEpochs();
                    if (this.epochs < this.numEpochs) {
                        this.batch = -1;
                    }
                }
            }
        } else {
            org.nd4j.linalg.dataset.DataSet dataSet = next = num == -1 ? (org.nd4j.linalg.dataset.DataSet)this.iter.next() : this.iter.next(num);
            if (next == null) {
                throw new IllegalStateException("Iterator returned null DataSet");
            }
            if (!this.iter.hasNext()) {
                this.trackEpochs();
                if (this.epochs < this.numEpochs) {
                    this.iter.reset();
                    this.lastBatch = this.batch;
                    this.batch = 0;
                }
            }
        }
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((DataSet)next);
        }
        return next;
    }

    public void trackEpochs() {
        ++this.epochs;
        this.newEpoch = true;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        return this.next(-1);
    }

    public int inputColumns() {
        return this.iter.inputColumns();
    }

    public int totalOutcomes() {
        return this.iter.totalOutcomes();
    }

    public boolean resetSupported() {
        return this.iter.resetSupported();
    }

    public boolean asyncSupported() {
        return this.iter.asyncSupported();
    }

    public void reset() {
        if (!this.iter.resetSupported()) {
            throw new IllegalStateException("Cannot reset MultipleEpochsIterator with base iter that does not support reset");
        }
        this.epochs = 0;
        this.lastBatch = this.batch;
        this.batch = 0;
        this.iterationsCounter.set(0L);
        this.iter.reset();
    }

    public int batch() {
        return this.iter.batch();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return this.iter.getLabels();
    }

    public boolean hasNext() {
        if (this.iterationsCounter.get() >= this.totalIterations) {
            return false;
        }
        if (this.newEpoch) {
            log.info("Epoch " + this.epochs + ", number of batches completed " + this.lastBatch);
            this.newEpoch = false;
        }
        if (this.iter == null) {
            return this.epochs < this.numEpochs && (!this.batchedDS.isEmpty() && this.batchedDS.size() > this.batch || this.batchedDS.isEmpty());
        }
        return this.epochs < this.numEpochs || this.iter.hasNext() && (this.epochs == 0 || this.epochs == this.numEpochs);
    }

    public void remove() {
        this.iter.remove();
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

