/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ArrayList;
import java.util.Collection;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointMultiDataSetIterator
implements MultiDataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(JointMultiDataSetIterator.class);
    protected MultiDataSetPreProcessor preProcessor;
    protected Collection<DataSetIterator> iterators;
    protected int outcome = -1;

    public JointMultiDataSetIterator(DataSetIterator ... iterators) {
        this.iterators = new ArrayList<DataSetIterator>();
        for (DataSetIterator i : iterators) {
            ((ArrayList)this.iterators).add(i);
        }
    }

    public JointMultiDataSetIterator(int outcome, DataSetIterator ... iterators) {
        this(iterators);
        this.outcome = outcome;
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next(int num) {
        throw new UnsupportedOperationException();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public boolean resetSupported() {
        boolean sup = true;
        for (DataSetIterator i : this.iterators) {
            if (i.resetSupported()) continue;
            sup = false;
            break;
        }
        return sup;
    }

    public boolean asyncSupported() {
        boolean sup = true;
        for (DataSetIterator i : this.iterators) {
            if (i.asyncSupported()) continue;
            sup = false;
            break;
        }
        return sup;
    }

    public void reset() {
        for (DataSetIterator i : this.iterators) {
            i.reset();
        }
    }

    public boolean hasNext() {
        boolean has = true;
        for (DataSetIterator i : this.iterators) {
            if (i.hasNext()) continue;
            has = false;
            break;
        }
        return has;
    }

    public org.nd4j.linalg.dataset.api.MultiDataSet next() {
        ArrayList<INDArray> features = new ArrayList<INDArray>();
        ArrayList<INDArray> labels = new ArrayList<INDArray>();
        ArrayList<INDArray> featuresMask = new ArrayList<INDArray>();
        ArrayList<INDArray> labelsMask = new ArrayList<INDArray>();
        boolean hasFM = false;
        boolean hasLM = false;
        int cnt = 0;
        for (DataSetIterator i : this.iterators) {
            DataSet ds = (DataSet)i.next();
            features.add(ds.getFeatures());
            featuresMask.add(ds.getFeaturesMaskArray());
            if (this.outcome < 0 || cnt == this.outcome) {
                labels.add(ds.getLabels());
                labelsMask.add(ds.getLabelsMaskArray());
            }
            if (ds.getFeaturesMaskArray() != null) {
                hasFM = true;
            }
            if (ds.getLabelsMaskArray() != null) {
                hasLM = true;
            }
            ++cnt;
        }
        INDArray[] fm = hasFM ? featuresMask.toArray(new INDArray[0]) : null;
        INDArray[] lm = hasLM ? labelsMask.toArray(new INDArray[0]) : null;
        MultiDataSet mds = new MultiDataSet(features.toArray(new INDArray[0]), labels.toArray(new INDArray[0]), fm, lm);
        if (this.preProcessor != null) {
            this.preProcessor.preProcess((org.nd4j.linalg.dataset.api.MultiDataSet)mds);
        }
        return mds;
    }

    public void remove() {
    }

    public JointMultiDataSetIterator() {
    }

    public JointMultiDataSetIterator(MultiDataSetPreProcessor preProcessor, Collection<DataSetIterator> iterators, int outcome) {
        this.preProcessor = preProcessor;
        this.iterators = iterators;
        this.outcome = outcome;
    }
}

