/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class CombinedPreProcessor
implements DataSetPreProcessor {
    private List<DataSetPreProcessor> preProcessors;

    private CombinedPreProcessor() {
    }

    public void preProcess(DataSet toPreProcess) {
        for (DataSetPreProcessor preProcessor : this.preProcessors) {
            preProcessor.preProcess(toPreProcess);
        }
    }

    public static class Builder {
        private List<DataSetPreProcessor> preProcessors = new ArrayList<DataSetPreProcessor>();

        public Builder addPreProcessor(@NonNull DataSetPreProcessor preProcessor) {
            if (preProcessor == null) {
                throw new NullPointerException("preProcessor is marked @NonNull but is null");
            }
            this.preProcessors.add(preProcessor);
            return this;
        }

        public Builder addPreProcessor(int idx, @NonNull DataSetPreProcessor preProcessor) {
            if (preProcessor == null) {
                throw new NullPointerException("preProcessor is marked @NonNull but is null");
            }
            this.preProcessors.add(idx, preProcessor);
            return this;
        }

        public CombinedPreProcessor build() {
            CombinedPreProcessor preProcessor = new CombinedPreProcessor();
            preProcessor.preProcessors = this.preProcessors;
            return preProcessor;
        }
    }
}

