/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.ui.components.chart.Chart;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChartHistogram
extends Chart {
    public static final String COMPONENT_TYPE = "ChartHistogram";
    private List<Double> lowerBounds = new ArrayList<Double>();
    private List<Double> upperBounds = new ArrayList<Double>();
    private List<Double> yValues = new ArrayList<Double>();

    public ChartHistogram(Builder builder) {
        super(COMPONENT_TYPE, builder);
        this.lowerBounds = builder.lowerBounds;
        this.upperBounds = builder.upperBounds;
        this.yValues = builder.yValues;
    }

    public ChartHistogram() {
        super(COMPONENT_TYPE);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChartHistogram(lowerBounds=");
        if (this.lowerBounds != null) {
            sb.append(this.lowerBounds);
        } else {
            sb.append("[]");
        }
        sb.append(",upperBounds=");
        if (this.upperBounds != null) {
            sb.append(this.upperBounds);
        } else {
            sb.append("[]");
        }
        sb.append(",yValues=");
        if (this.yValues != null) {
            sb.append(this.yValues);
        } else {
            sb.append("[]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartHistogram)) {
            return false;
        }
        ChartHistogram other = (ChartHistogram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Double> this$lowerBounds = this.getLowerBounds();
        List<Double> other$lowerBounds = other.getLowerBounds();
        if (this$lowerBounds == null ? other$lowerBounds != null : !((Object)this$lowerBounds).equals(other$lowerBounds)) {
            return false;
        }
        List<Double> this$upperBounds = this.getUpperBounds();
        List<Double> other$upperBounds = other.getUpperBounds();
        if (this$upperBounds == null ? other$upperBounds != null : !((Object)this$upperBounds).equals(other$upperBounds)) {
            return false;
        }
        List<Double> this$yValues = this.getYValues();
        List<Double> other$yValues = other.getYValues();
        return !(this$yValues == null ? other$yValues != null : !((Object)this$yValues).equals(other$yValues));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChartHistogram;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Double> $lowerBounds = this.getLowerBounds();
        result = result * 59 + ($lowerBounds == null ? 43 : ((Object)$lowerBounds).hashCode());
        List<Double> $upperBounds = this.getUpperBounds();
        result = result * 59 + ($upperBounds == null ? 43 : ((Object)$upperBounds).hashCode());
        List<Double> $yValues = this.getYValues();
        result = result * 59 + ($yValues == null ? 43 : ((Object)$yValues).hashCode());
        return result;
    }

    public List<Double> getLowerBounds() {
        return this.lowerBounds;
    }

    public List<Double> getUpperBounds() {
        return this.upperBounds;
    }

    public List<Double> getYValues() {
        return this.yValues;
    }

    public void setLowerBounds(List<Double> lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public void setUpperBounds(List<Double> upperBounds) {
        this.upperBounds = upperBounds;
    }

    public void setYValues(List<Double> yValues) {
        this.yValues = yValues;
    }

    public static class Builder
    extends Chart.Builder<Builder> {
        private List<Double> lowerBounds = new ArrayList<Double>();
        private List<Double> upperBounds = new ArrayList<Double>();
        private List<Double> yValues = new ArrayList<Double>();

        public Builder(String title, StyleChart style) {
            super(title, style);
        }

        public Builder addBin(double lower, double upper, double yValue) {
            this.lowerBounds.add(lower);
            this.upperBounds.add(upper);
            this.yValues.add(yValue);
            return this;
        }

        public ChartHistogram build() {
            return new ChartHistogram(this);
        }
    }
}

