/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.primitives.Pair;

public class ZeroPadding1DLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer> {
    private int[] padding;

    public ZeroPadding1DLayer(NeuralNetConfiguration conf) {
        super(conf);
        this.padding = ((org.deeplearning4j.nn.conf.layers.ZeroPadding1DLayer)conf.getLayer()).getPadding();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        long[] inShape = this.input.shape();
        INDArray epsNext = epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.padding[0], (long)((long)this.padding[0] + inShape[2]))});
        return new Pair((Object)new DefaultGradient(), (Object)workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsNext));
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        long[] inShape = this.input.shape();
        long paddedOut = inShape[2] + (long)this.padding[0] + (long)this.padding[1];
        long[] outShape = new long[]{inShape[0], inShape[1], paddedOut};
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, outShape, 'c');
        out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.padding[0], (long)((long)this.padding[0] + inShape[2]))}, this.input);
        return out;
    }

    public Layer clone() {
        return new ZeroPadding1DLayer(this.conf.clone());
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }
}

