/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.serde.BaseNetConfigDeserializer;
import org.deeplearning4j.nn.conf.weightnoise.DropConnect;
import org.nd4j.shade.jackson.core.JsonLocation;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.node.ArrayNode;
import org.nd4j.shade.jackson.databind.node.ObjectNode;

public class MultiLayerConfigurationDeserializer
extends BaseNetConfigDeserializer<MultiLayerConfiguration> {
    public MultiLayerConfigurationDeserializer(JsonDeserializer<?> defaultDeserializer) {
        super(defaultDeserializer, MultiLayerConfiguration.class);
    }

    @Override
    public MultiLayerConfiguration deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        long charOffsetStart = jp.getCurrentLocation().getCharOffset();
        MultiLayerConfiguration conf = (MultiLayerConfiguration)this.defaultDeserializer.deserialize(jp, ctxt);
        Layer[] layers = new Layer[conf.getConfs().size()];
        for (int i = 0; i < layers.length; ++i) {
            layers[i] = conf.getConf(i).getLayer();
        }
        boolean attemptIUpdaterFromLegacy = this.requiresIUpdaterFromLegacy(layers);
        if (attemptIUpdaterFromLegacy) {
            JsonLocation endLocation = jp.getCurrentLocation();
            long charOffsetEnd = endLocation.getCharOffset();
            String jsonSubString = endLocation.getSourceRef().toString().substring((int)charOffsetStart - 1, (int)charOffsetEnd);
            ObjectMapper om = NeuralNetConfiguration.mapper();
            JsonNode rootNode = om.readTree(jsonSubString);
            ArrayNode confsNode = (ArrayNode)rootNode.get("confs");
            for (int i = 0; i < layers.length; ++i) {
                double d;
                ObjectNode on = (ObjectNode)confsNode.get(i);
                ObjectNode confNode = null;
                if (layers[i] instanceof BaseLayer && ((BaseLayer)layers[i]).getIUpdater() == null) {
                    if (!on.has("layer")) continue;
                    confNode = on;
                    on = (ObjectNode)on.get("layer");
                    on = (ObjectNode)on.elements().next();
                    this.handleUpdaterBackwardCompatibility((BaseLayer)layers[i], on);
                }
                if (layers[i].getIDropout() != null || !on.has("dropOut") || Double.isNaN(d = on.get("dropOut").asDouble())) continue;
                if (confNode != null && layers[i] instanceof BaseLayer && confNode.has("useDropConnect") && confNode.get("useDropConnect").asBoolean(false)) {
                    ((BaseLayer)layers[i]).setWeightNoise(new DropConnect(d));
                    continue;
                }
                if (!(d > 0.0)) continue;
                layers[i].setIDropout(new Dropout(d));
            }
        }
        return conf;
    }
}

