/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.inputs;

import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonIgnore;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonSubTypes;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InputTypeFeedForward.class, name="FeedForward"), @JsonSubTypes.Type(value=InputTypeRecurrent.class, name="Recurrent"), @JsonSubTypes.Type(value=InputTypeConvolutional.class, name="Convolutional"), @JsonSubTypes.Type(value=InputTypeConvolutionalFlat.class, name="ConvolutionalFlat"), @JsonSubTypes.Type(value=InputTypeConvolutional3D.class, name="Convolutional3D")})
public abstract class InputType
implements Serializable {
    @JsonIgnore
    public abstract Type getType();

    public abstract String toString();

    @JsonIgnore
    public abstract long arrayElementsPerExample();

    @JsonIgnore
    public abstract long[] getShape(boolean var1);

    public long[] getShape() {
        return this.getShape(false);
    }

    public static InputType feedForward(long size) {
        return new InputTypeFeedForward(size);
    }

    public static InputType recurrent(long size) {
        return new InputTypeRecurrent(size);
    }

    public static InputType recurrent(long size, long timeSeriesLength) {
        return new InputTypeRecurrent(size, timeSeriesLength);
    }

    public static InputType convolutional(long height, long width, long depth) {
        return new InputTypeConvolutional(height, width, depth);
    }

    public static InputType convolutional3D(long depth, long height, long width, long channels) {
        return new InputTypeConvolutional3D(depth, height, width, channels);
    }

    public static InputType convolutionalFlat(long height, long width, long depth) {
        return new InputTypeConvolutionalFlat(height, width, depth);
    }

    public static InputType inferInputType(INDArray inputArray) {
        switch (inputArray.rank()) {
            case 2: {
                return InputType.feedForward((int)inputArray.size(1));
            }
            case 3: {
                return InputType.recurrent((int)inputArray.size(1), (int)inputArray.size(2));
            }
            case 4: {
                return InputType.convolutional((int)inputArray.size(2), (int)inputArray.size(3), (int)inputArray.size(1));
            }
            case 5: {
                return InputType.convolutional3D((int)inputArray.size(2), (int)inputArray.size(3), (int)inputArray.size(4), (int)inputArray.size(1));
            }
        }
        throw new IllegalArgumentException("Cannot infer input type for array with shape: " + Arrays.toString(inputArray.shape()));
    }

    public static InputType[] inferInputTypes(INDArray ... inputArrays) {
        InputType[] out = new InputType[inputArrays.length];
        for (int i = 0; i < inputArrays.length; ++i) {
            out[i] = InputType.inferInputType(inputArrays[i]);
        }
        return out;
    }

    public static class InputTypeConvolutionalFlat
    extends InputType {
        private long height;
        private long width;
        private long depth;

        @Override
        public Type getType() {
            return Type.CNNFlat;
        }

        public long getFlattenedSize() {
            return this.height * this.width * this.depth;
        }

        public InputType getUnflattenedType() {
            return InputType.convolutional(this.height, this.width, this.depth);
        }

        @Override
        public String toString() {
            return "InputTypeConvolutionalFlat(h=" + this.height + ",w=" + this.width + ",d=" + this.depth + ")";
        }

        @Override
        public long arrayElementsPerExample() {
            return this.height * this.width * this.depth;
        }

        @Override
        public long[] getShape(boolean includeBatchDim) {
            if (includeBatchDim) {
                return new long[]{-1L, this.depth, this.height, this.width};
            }
            return new long[]{this.depth, this.height, this.width};
        }

        public InputTypeConvolutionalFlat(long height, long width, long depth) {
            this.height = height;
            this.width = width;
            this.depth = depth;
        }

        public long getHeight() {
            return this.height;
        }

        public long getWidth() {
            return this.width;
        }

        public long getDepth() {
            return this.depth;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public void setDepth(long depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutionalFlat)) {
                return false;
            }
            InputTypeConvolutionalFlat other = (InputTypeConvolutionalFlat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getDepth() == other.getDepth();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutionalFlat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $height = this.getHeight();
            result = result * 59 + (int)($height >>> 32 ^ $height);
            long $width = this.getWidth();
            result = result * 59 + (int)($width >>> 32 ^ $width);
            long $depth = this.getDepth();
            result = result * 59 + (int)($depth >>> 32 ^ $depth);
            return result;
        }

        public InputTypeConvolutionalFlat() {
        }
    }

    public static class InputTypeConvolutional3D
    extends InputType {
        private long depth;
        private long height;
        private long width;
        private long channels;

        @Override
        public Type getType() {
            return Type.CNN3D;
        }

        @Override
        public String toString() {
            return "InputTypeConvolutional3D(d=" + this.depth + ",h=" + this.height + ",w=" + this.width + ",c=" + this.channels + ")";
        }

        @Override
        public long arrayElementsPerExample() {
            return this.height * this.width * this.depth * this.channels;
        }

        @Override
        public long[] getShape(boolean includeBatchDim) {
            if (includeBatchDim) {
                return new long[]{-1L, this.channels, this.depth, this.height, this.width};
            }
            return new long[]{this.channels, this.depth, this.height, this.width};
        }

        public InputTypeConvolutional3D(long depth, long height, long width, long channels) {
            this.depth = depth;
            this.height = height;
            this.width = width;
            this.channels = channels;
        }

        public long getDepth() {
            return this.depth;
        }

        public long getHeight() {
            return this.height;
        }

        public long getWidth() {
            return this.width;
        }

        public long getChannels() {
            return this.channels;
        }

        public void setDepth(long depth) {
            this.depth = depth;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public void setChannels(long channels) {
            this.channels = channels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutional3D)) {
                return false;
            }
            InputTypeConvolutional3D other = (InputTypeConvolutional3D)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDepth() != other.getDepth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getChannels() == other.getChannels();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutional3D;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $depth = this.getDepth();
            result = result * 59 + (int)($depth >>> 32 ^ $depth);
            long $height = this.getHeight();
            result = result * 59 + (int)($height >>> 32 ^ $height);
            long $width = this.getWidth();
            result = result * 59 + (int)($width >>> 32 ^ $width);
            long $channels = this.getChannels();
            result = result * 59 + (int)($channels >>> 32 ^ $channels);
            return result;
        }

        public InputTypeConvolutional3D() {
        }
    }

    public static class InputTypeConvolutional
    extends InputType {
        private long height;
        private long width;
        private long channels;

        @Deprecated
        public long getDepth() {
            return this.channels;
        }

        @Deprecated
        public void setDepth(long depth) {
            this.channels = depth;
        }

        @Override
        public Type getType() {
            return Type.CNN;
        }

        @Override
        public String toString() {
            return "InputTypeConvolutional(h=" + this.height + ",w=" + this.width + ",c=" + this.channels + ")";
        }

        @Override
        public long arrayElementsPerExample() {
            return this.height * this.width * this.channels;
        }

        @Override
        public long[] getShape(boolean includeBatchDim) {
            if (includeBatchDim) {
                return new long[]{-1L, this.channels, this.height, this.width};
            }
            return new long[]{this.channels, this.height, this.width};
        }

        public InputTypeConvolutional(long height, long width, long channels) {
            this.height = height;
            this.width = width;
            this.channels = channels;
        }

        public long getHeight() {
            return this.height;
        }

        public long getWidth() {
            return this.width;
        }

        public long getChannels() {
            return this.channels;
        }

        public void setHeight(long height) {
            this.height = height;
        }

        public void setWidth(long width) {
            this.width = width;
        }

        public void setChannels(long channels) {
            this.channels = channels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeConvolutional)) {
                return false;
            }
            InputTypeConvolutional other = (InputTypeConvolutional)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getChannels() == other.getChannels();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeConvolutional;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $height = this.getHeight();
            result = result * 59 + (int)($height >>> 32 ^ $height);
            long $width = this.getWidth();
            result = result * 59 + (int)($width >>> 32 ^ $width);
            long $channels = this.getChannels();
            result = result * 59 + (int)($channels >>> 32 ^ $channels);
            return result;
        }

        public InputTypeConvolutional() {
        }
    }

    public static class InputTypeRecurrent
    extends InputType {
        private long size;
        private long timeSeriesLength;

        public InputTypeRecurrent(long size) {
            this(size, -1L);
        }

        @Override
        public Type getType() {
            return Type.RNN;
        }

        @Override
        public String toString() {
            if (this.timeSeriesLength > 0L) {
                return "InputTypeRecurrent(" + this.size + ",timeSeriesLength=" + this.timeSeriesLength + ")";
            }
            return "InputTypeRecurrent(" + this.size + ")";
        }

        @Override
        public long arrayElementsPerExample() {
            if (this.timeSeriesLength <= 0L) {
                throw new IllegalStateException("Cannot calculate number of array elements per example: time series length is not set. Use InputType.recurrent(int size, int timeSeriesLength) instead?");
            }
            return this.timeSeriesLength * this.size;
        }

        @Override
        public long[] getShape(boolean includeBatchDim) {
            if (includeBatchDim) {
                return new long[]{-1L, this.size, this.timeSeriesLength};
            }
            return new long[]{this.size, this.timeSeriesLength};
        }

        public long getSize() {
            return this.size;
        }

        public long getTimeSeriesLength() {
            return this.timeSeriesLength;
        }

        public InputTypeRecurrent() {
        }

        public InputTypeRecurrent(long size, long timeSeriesLength) {
            this.size = size;
            this.timeSeriesLength = timeSeriesLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeRecurrent)) {
                return false;
            }
            InputTypeRecurrent other = (InputTypeRecurrent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            return this.getTimeSeriesLength() == other.getTimeSeriesLength();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeRecurrent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            long $timeSeriesLength = this.getTimeSeriesLength();
            result = result * 59 + (int)($timeSeriesLength >>> 32 ^ $timeSeriesLength);
            return result;
        }
    }

    public static class InputTypeFeedForward
    extends InputType {
        private long size;

        @Override
        public Type getType() {
            return Type.FF;
        }

        @Override
        public String toString() {
            return "InputTypeFeedForward(" + this.size + ")";
        }

        @Override
        public long arrayElementsPerExample() {
            return this.size;
        }

        @Override
        public long[] getShape(boolean includeBatchDim) {
            if (includeBatchDim) {
                return new long[]{-1L, this.size};
            }
            return new long[]{this.size};
        }

        public InputTypeFeedForward(long size) {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public InputTypeFeedForward() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputTypeFeedForward)) {
                return false;
            }
            InputTypeFeedForward other = (InputTypeFeedForward)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof InputTypeFeedForward;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            return result;
        }
    }

    public static enum Type {
        FF,
        RNN,
        CNN,
        CNNFlat,
        CNN3D;

    }
}

