/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.tokenization.tokenizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.text.tokenization.tokenizer.TokenPreProcess;
import org.deeplearning4j.text.tokenization.tokenizer.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamTokenizer
implements Tokenizer {
    private StreamTokenizer streamTokenizer;
    private TokenPreProcess tokenPreProcess;
    private List<String> tokens = new ArrayList<String>();
    private AtomicInteger position = new AtomicInteger(0);
    protected static final Logger log = LoggerFactory.getLogger(DefaultStreamTokenizer.class);

    public DefaultStreamTokenizer(InputStream is) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        this.streamTokenizer = new StreamTokenizer(r);
    }

    private boolean streamHasMoreTokens() {
        if (this.streamTokenizer.ttype != -1) {
            try {
                this.streamTokenizer.nextToken();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        }
        return this.streamTokenizer.ttype != -1 && this.streamTokenizer.ttype != -1;
    }

    @Override
    public boolean hasMoreTokens() {
        log.info("Tokens size: [" + this.tokens.size() + "], position: [" + this.position.get() + "]");
        if (!this.tokens.isEmpty()) {
            return this.position.get() < this.tokens.size();
        }
        return this.streamHasMoreTokens();
    }

    @Override
    public int countTokens() {
        return this.getTokens().size();
    }

    @Override
    public String nextToken() {
        if (!this.tokens.isEmpty() && this.position.get() < this.tokens.size()) {
            return this.tokens.get(this.position.getAndIncrement());
        }
        return this.nextTokenFromStream();
    }

    private String nextTokenFromStream() {
        StringBuilder sb = new StringBuilder();
        if (this.streamTokenizer.ttype == -3) {
            sb.append(this.streamTokenizer.sval);
        } else if (this.streamTokenizer.ttype == -2) {
            sb.append(this.streamTokenizer.nval);
        } else if (this.streamTokenizer.ttype == 10) {
            try {
                while (this.streamTokenizer.ttype == 10) {
                    this.streamTokenizer.nextToken();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (this.streamHasMoreTokens()) {
            return this.nextTokenFromStream();
        }
        String ret = sb.toString();
        if (this.tokenPreProcess != null) {
            ret = this.tokenPreProcess.preProcess(ret);
        }
        return ret;
    }

    @Override
    public List<String> getTokens() {
        if (!this.tokens.isEmpty()) {
            return this.tokens;
        }
        log.info("Starting prebuffering...");
        while (this.streamHasMoreTokens()) {
            this.tokens.add(this.nextTokenFromStream());
        }
        log.info("Tokens prefetch finished. Tokens size: [" + this.tokens.size() + "]");
        return this.tokens;
    }

    @Override
    public void setTokenPreProcessor(TokenPreProcess tokenPreProcessor) {
        this.tokenPreProcess = tokenPreProcessor;
    }
}

